/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.HappinessRegistry;
import com.minecolonies.api.entity.citizen.happiness.IHappinessSupplierWrapper;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DynamicHappinessSupplier
implements IHappinessSupplierWrapper {
    private ResourceLocation key;
    private double lastValue = 0.0;

    public DynamicHappinessSupplier(ResourceLocation key) {
        this.key = key;
    }

    public DynamicHappinessSupplier() {
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("id", this.key.toString());
        compoundTag.putDouble("Value", this.lastValue);
        return compoundTag;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        this.key = ResourceLocation.parse((String)nbt.getString("id"));
        this.lastValue = nbt.getDouble("Value");
    }

    @Override
    public double getValue(ICitizenData citizenData) {
        HappinessRegistry.HappinessFunctionEntry function = (HappinessRegistry.HappinessFunctionEntry)IMinecoloniesAPI.getInstance().getHappinessFunctionRegistry().get(this.key);
        if (function == null) {
            return this.lastValue;
        }
        this.lastValue = function.getDoubleSupplier().apply(citizenData);
        return this.lastValue;
    }

    @Override
    public double getLastCachedValue() {
        return this.lastValue;
    }
}

