/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.statemachine.basestatemachine;

import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.transitions.IStateMachineTransition;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicTransition<S extends IState>
implements IStateMachineTransition<S> {
    @Nullable
    private final S state;
    @NotNull
    private final BooleanSupplier condition;
    @NotNull
    private final Supplier<S> nextState;

    public BasicTransition(@NotNull S state, @NotNull BooleanSupplier condition, @NotNull Supplier<S> nextState) {
        this.state = state;
        this.condition = condition;
        this.nextState = nextState;
    }

    protected BasicTransition(@NotNull BooleanSupplier condition, @NotNull Supplier<S> nextState) {
        this.state = null;
        this.condition = condition;
        this.nextState = nextState;
    }

    @Override
    public S getState() {
        return this.state;
    }

    @Override
    public S getNextState() {
        return (S)((IState)this.nextState.get());
    }

    @Override
    public boolean checkCondition() {
        return this.condition.getAsBoolean();
    }
}

