/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeCraftingType<C extends RecipeInput, T extends Recipe<C>>
extends CraftingType {
    private final RecipeType<T> recipeType;
    private final Predicate<RecipeHolder<T>> predicate;

    public RecipeCraftingType(@NotNull ResourceLocation id, @NotNull RecipeType<T> recipeType, @Nullable Predicate<RecipeHolder<T>> predicate) {
        super(id);
        this.recipeType = recipeType;
        this.predicate = predicate;
    }

    @Override
    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @NotNull Level world) {
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        for (RecipeHolder recipe : recipeManager.getAllRecipesFor(this.recipeType)) {
            if (this.predicate != null && !this.predicate.test(recipe)) continue;
            this.tryAddingVanillaRecipe(recipes, recipe, world);
        }
        return recipes;
    }

    private void tryAddingVanillaRecipe(@NotNull List<IGenericRecipe> recipes, @NotNull RecipeHolder<T> holder, @NotNull Level world) {
        Recipe recipe = holder.value();
        if (recipe.isSpecial() || recipe.getResultItem((HolderLookup.Provider)world.registryAccess()).isEmpty()) {
            return;
        }
        try {
            IGenericRecipe genericRecipe = GenericRecipe.of(holder, world);
            if (genericRecipe == null || genericRecipe.getInputs().isEmpty()) {
                return;
            }
            recipes.add(genericRecipe);
        }
        catch (Exception ex) {
            Log.getLogger().warn("Error evaluating recipe " + String.valueOf(holder.id()) + "; ignoring.", (Throwable)ex);
        }
    }
}

