/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PublicCrafting
extends AbstractCrafting {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(PublicCrafting.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());

    public PublicCrafting(@NotNull ItemStack stack, int count, IToken<?> recipeToken) {
        super(stack, count, count, recipeToken);
    }

    public static CompoundTag serialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, PublicCrafting input) {
        CompoundTag compound = new CompoundTag();
        compound.put("Stack", input.getStack().saveOptional(provider));
        compound.putInt("Count", input.getCount());
        CompoundTag tokenCompound = StandardFactoryController.getInstance().serializeTag(provider, input.getRecipeID());
        compound.put("Token", (Tag)tokenCompound);
        return compound;
    }

    public static PublicCrafting deserialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, CompoundTag compound) {
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.getCompound("Stack"), provider);
        int count = compound.getInt("Count");
        IToken token = null;
        if (compound.contains("Token")) {
            token = (IToken)StandardFactoryController.getInstance().deserializeTag(provider, compound.getCompound("Token"));
        }
        return new PublicCrafting(stack, count, token);
    }

    public static void serialize(IFactoryController controller, RegistryFriendlyByteBuf buffer, PublicCrafting input) {
        Utils.serializeCodecMess(buffer, input.getStack());
        buffer.writeInt(input.getCount());
        StandardFactoryController.getInstance().serialize(buffer, input.getRecipeID());
    }

    public static PublicCrafting deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) {
        ItemStack stack = Utils.deserializeCodecMess(buffer);
        int count = buffer.readInt();
        IToken token = (IToken)StandardFactoryController.getInstance().deserialize(buffer);
        return new PublicCrafting(stack, count, token);
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

