/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.registry;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BuildingEntry {
    private final AbstractBlockHut<?> buildingBlock;
    private final BiFunction<IColony, BlockPos, IBuilding> buildingProducer;
    private final ResourceLocation registryName;
    private List<ModuleProducer> buildingModuleProducers;
    private final Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer;

    public String getTranslationKey() {
        return "com." + this.registryName.getNamespace() + ".building." + this.registryName.getPath();
    }

    public AbstractBlockHut<?> getBuildingBlock() {
        return this.buildingBlock;
    }

    public IBuilding produceBuilding(BlockPos position, IColony colony) {
        IBuilding building = this.buildingProducer.apply(colony, position);
        for (ModuleProducer moduleTuple : this.buildingModuleProducers) {
            if (moduleTuple.moduleProducer == null) continue;
            building.registerModule(moduleTuple.moduleProducer.get().setBuilding(building).setProducer(moduleTuple));
        }
        building.setBuildingType(this);
        return building;
    }

    public IBuildingView produceBuildingView(BlockPos position, IColonyView colony) {
        IBuildingView buildingView = this.buildingViewProducer.get().apply(colony, position);
        buildingView.setBuildingType(this);
        for (ModuleProducer moduleSet : this.buildingModuleProducers) {
            if (moduleSet.viewProducer == null) continue;
            buildingView.registerModule(moduleSet.viewProducer.get().get().setProducer(moduleSet));
        }
        return buildingView;
    }

    public List<ModuleProducer> getModuleProducers() {
        return this.buildingModuleProducers;
    }

    private BuildingEntry(ResourceLocation registryName, AbstractBlockHut<?> buildingBlock, BiFunction<IColony, BlockPos, IBuilding> buildingProducer, Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer, List<ModuleProducer> buildingModuleProducers) {
        this.registryName = registryName;
        this.buildingBlock = buildingBlock;
        this.buildingProducer = buildingProducer;
        this.buildingViewProducer = buildingViewProducer;
        this.buildingModuleProducers = buildingModuleProducers;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Nullable
    public static IBuildingModule produceModuleWithoutBuilding(String key) {
        ModuleProducer<? extends IBuildingModule, ? extends IBuildingModuleView> producer = ModuleProducer.ALL_MODULES.get(key);
        if (producer.hasServerModule()) {
            IBuildingModule module = producer.moduleProducer.get();
            module.setProducer(producer);
            return module;
        }
        return null;
    }

    @Nullable
    public static IBuildingModuleView produceViewWithoutBuilding(String key) {
        ModuleProducer<? extends IBuildingModule, ? extends IBuildingModuleView> producer = ModuleProducer.ALL_MODULES.get(key);
        if (producer.hasView()) {
            return producer.viewProducer.get().get();
        }
        return null;
    }

    public static Map<String, ModuleProducer> getALlModuleProducers() {
        return ImmutableMap.copyOf(ModuleProducer.ALL_MODULES);
    }

    public static ModuleProducer getProducer(String key) {
        return ModuleProducer.ALL_MODULES.get(key);
    }

    public static ModuleProducer getProducer(int runtimeID) {
        for (ModuleProducer<? extends IBuildingModule, ? extends IBuildingModuleView> producer : ModuleProducer.ALL_MODULES.values()) {
            if (producer.getRuntimeID() != runtimeID) continue;
            return producer;
        }
        return null;
    }

    public static class ModuleProducer<MODULECLASS extends IBuildingModule, VIEWCLASS extends IBuildingModuleView> {
        private static final Map<String, ModuleProducer<? extends IBuildingModule, ? extends IBuildingModuleView>> ALL_MODULES = new HashMap<String, ModuleProducer<? extends IBuildingModule, ? extends IBuildingModuleView>>();
        private static int runtimeIdGenerator = 0;
        private final int id;
        public final String key;
        private final Supplier<Supplier<IBuildingModuleView>> viewProducer;
        private final Supplier<IBuildingModule> moduleProducer;

        public ModuleProducer(String key, Supplier<IBuildingModule> moduleProducer, Supplier<Supplier<IBuildingModuleView>> viewProducer) {
            this.key = key;
            this.id = ++runtimeIdGenerator;
            this.viewProducer = viewProducer;
            this.moduleProducer = moduleProducer;
            ModuleProducer<? extends IBuildingModule, ? extends IBuildingModuleView> previous = ALL_MODULES.put(key, this);
            if (previous != null) {
                throw new RuntimeException("Tried to register existing module: " + key + " again!");
            }
        }

        public int getRuntimeID() {
            return this.id;
        }

        public boolean hasView() {
            return this.viewProducer != null;
        }

        public boolean hasServerModule() {
            return this.moduleProducer != null;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleProducer that = (ModuleProducer)o;
            return this.id == that.id;
        }
    }

    public static final class Builder {
        private AbstractBlockHut<?> buildingBlock;
        private BiFunction<IColony, BlockPos, IBuilding> buildingProducer;
        private Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer;
        private List<ModuleProducer> buildingModuleProducers = new ArrayList<ModuleProducer>();
        private ResourceLocation registryName;

        public Builder setBuildingBlock(AbstractBlockHut<?> buildingBlock) {
            this.buildingBlock = buildingBlock;
            return this;
        }

        public Builder setBuildingProducer(BiFunction<IColony, BlockPos, IBuilding> buildingProducer) {
            this.buildingProducer = buildingProducer;
            return this;
        }

        public Builder setBuildingViewProducer(Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer) {
            this.buildingViewProducer = buildingViewProducer;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public BuildingEntry createBuildingEntry() {
            Objects.requireNonNull(this.buildingBlock);
            Objects.requireNonNull(this.buildingProducer);
            Objects.requireNonNull(this.buildingViewProducer);
            Objects.requireNonNull(this.registryName);
            return new BuildingEntry(this.registryName, this.buildingBlock, this.buildingProducer, this.buildingViewProducer, this.buildingModuleProducers);
        }

        public Builder addBuildingModuleProducer(ModuleProducer moduleSet) {
            this.buildingModuleProducers.add(moduleSet);
            return this;
        }
    }
}

