/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildingextensions;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.modules.IBuildingExtensionModule;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.modules.IModuleContainer;
import com.minecolonies.api.util.BlockPosUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IBuildingExtension
extends IModuleContainer<IBuildingExtensionModule> {
    @NotNull
    public BuildingExtensionRegistries.BuildingExtensionEntry getBuildingExtensionType();

    @NotNull
    public BlockPos getPosition();

    @Nullable
    public BlockPos getBuildingId();

    public void setBuilding(BlockPos var1);

    public void resetOwningBuilding();

    public boolean isTaken();

    public int getSqDistance(IBuildingView var1);

    @NotNull
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider var1);

    public void deserializeNBT(@NotNull HolderLookup.Provider var1, @NotNull CompoundTag var2);

    public void serialize(@NotNull RegistryFriendlyByteBuf var1);

    public void deserialize(@NotNull RegistryFriendlyByteBuf var1);

    public boolean isValidPlacement(IColony var1);

    public int hashCode();

    public boolean equals(Object var1);

    public ExtensionId getId();

    public record ExtensionId(BlockPos pos, BuildingExtensionRegistries.BuildingExtensionEntry entry) {
        public Tag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            BlockPosUtil.write(tag, "pos", this.pos);
            tag.putString("id", this.entry.getRegistryName().toString());
            return tag;
        }

        public static ExtensionId deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            return new ExtensionId(BlockPosUtil.read(nbt, "pos"), (BuildingExtensionRegistries.BuildingExtensionEntry)BuildingExtensionRegistries.getBuildingExtensionRegistry().get(ResourceLocation.parse((String)nbt.getString("id"))));
        }
    }
}

