/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.gui.containerfactory;

import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PipeContainerProvider
implements MenuProvider {
    private ContainerCreator container;
    private UpgradeTileEntity tileEntity;

    public PipeContainerProvider(ContainerCreator container, UpgradeTileEntity tileEntity) {
        this.container = container;
        this.tileEntity = tileEntity;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.tileEntity.getBlockState().getBlock().getDescriptionId());
    }

    public static void openGui(Player player, UpgradeTileEntity tileEntity, Direction direction, int index, ContainerCreator containerCreator) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)new PipeContainerProvider(containerCreator, tileEntity), packetBuffer -> {
                packetBuffer.writeBlockPos(tileEntity.getBlockPos());
                packetBuffer.writeEnum((Enum)direction);
                packetBuffer.writeInt(index);
            });
        }
    }

    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return this.container.create(i, playerInventory, playerEntity);
    }

    public static interface ContainerCreator {
        public AbstractContainerMenu create(int var1, Inventory var2, Player var3);
    }
}

