/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.part;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanel;
import org.cyclops.integratedscripting.GeneralConfig;
import org.cyclops.integratedscripting.IntegratedScripting;
import org.cyclops.integratedscripting.core.network.ScriptingNetworkHelpers;
import org.cyclops.integratedscripting.inventory.container.ContainerTerminalScripting;

public class PartTypeTerminalScripting
extends PartTypePanel<PartTypeTerminalScripting, PartStateEmpty<PartTypeTerminalScripting>> {
    public PartTypeTerminalScripting(String name) {
        super(name);
    }

    public InteractionResult onPartActivated(PartStateEmpty<PartTypeTerminalScripting> partState, BlockPos pos, Level world, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult hit) {
        if (this.isUpdate(partState) && !partState.isEnabled()) {
            player.displayClientMessage((Component)Component.translatable((String)"parttype.integrateddynamics.error.low_energy"), true);
            return InteractionResult.FAIL;
        }
        return super.onPartActivated(partState, pos, world, player, hand, heldItem, hit);
    }

    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlock();
    }

    public ModBase<?> getMod() {
        return IntegratedScripting._instance;
    }

    public boolean isUpdate(PartStateEmpty<PartTypeTerminalScripting> state) {
        return this.getConsumptionRate(state) > 0 && org.cyclops.integrateddynamics.GeneralConfig.energyConsumptionMultiplier > 0;
    }

    public int getConsumptionRate(PartStateEmpty<PartTypeTerminalScripting> state) {
        return GeneralConfig.terminalScriptingBaseConsumption;
    }

    protected PartStateEmpty<PartTypeTerminalScripting> constructDefaultState() {
        return new PartStateEmpty<PartTypeTerminalScripting>(this){

            public int getUpdateInterval() {
                return 1;
            }
        };
    }

    public Optional<MenuProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)PartTypeTerminalScripting.this.getTranslationKey());
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                return new ContainerTerminalScripting(id, playerInventory, (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (PartTypeTerminalScripting)((Object)data.getMiddle()), PartTypeTerminalScripting.this.createContainerInitData(((PartTarget)data.getRight()).getCenter()));
            }
        });
    }

    public void writeExtraGuiData(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        PacketCodec.write((RegistryFriendlyByteBuf)packetBuffer, (Object)pos);
        super.writeExtraGuiData(packetBuffer, pos, player);
        this.createContainerInitData(pos).writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
    }

    protected ContainerTerminalScripting.InitData createContainerInitData(PartPos pos) {
        Optional network = NetworkHelpers.getNetwork((PartPos)pos);
        Optional<List> scriptingNetwork = network.flatMap(ScriptingNetworkHelpers::getScriptingNetwork);
        IntArrayList availableDisks = scriptingNetwork.map(net -> net.getDisks().stream().sorted().collect(Collectors.toList())).map(IntArrayList::new).orElse(new IntArrayList());
        return new ContainerTerminalScripting.InitData((IntList)availableDisks);
    }
}

