/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.impl.AbstractAssumption;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.compiler.OptimizedAssumptionDependency;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedTVMCI;
import java.util.function.Consumer;
import java.util.logging.Level;
import jdk.vm.ci.meta.JavaKind;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;

public final class OptimizedAssumption
extends AbstractAssumption
implements JavaKind.FormatWithToString {
    private Entry dependencies;
    private int size;
    private int sizeAfterLastRemove;
    private static final Consumer<OptimizedAssumptionDependency> DISCARD_DEPENDENCY = e2 -> {};

    public OptimizedAssumption(String name) {
        super(name);
    }

    private OptimizedAssumption(Object name) {
        super(name);
    }

    static Assumption createAlwaysValid() {
        return new OptimizedAssumption(Lazy.ALWAYS_VALID_NAME);
    }

    @Override
    public void check() throws InvalidAssumptionException {
        if (!this.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new InvalidAssumptionException();
        }
    }

    @Override
    public void invalidate() {
        if (this.isValid) {
            this.invalidateImpl("");
        }
    }

    @Override
    public void invalidate(String message) {
        if (this.isValid) {
            this.invalidateImpl(message);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void invalidateImpl(String message) {
        if (!this.isValid) {
            return;
        }
        if (this.name == Lazy.ALWAYS_VALID_NAME) {
            throw new UnsupportedOperationException("Cannot invalidate this assumption - it is always valid");
        }
        OptionValues engineOptions = null;
        TruffleLogger logger = null;
        boolean logStackTrace = false;
        Entry e2 = this.dependencies;
        CharSequence reason = null;
        while (e2 != null) {
            OptimizedAssumptionDependency dependency = e2.awaitDependency();
            if (dependency != null) {
                if (reason == null) {
                    String useMessage;
                    String useName = this.name != null ? this.name.toString() : "";
                    String string = useMessage = message != null ? message : "";
                    reason = useName.isEmpty() && useMessage.isEmpty() ? "assumption invalidated" : (useName.isEmpty() ? useMessage : (useMessage.isEmpty() ? useName : new LazyReason(useName, useMessage)));
                }
                dependency.onAssumptionInvalidated(this, reason);
                if (engineOptions == null) {
                    OptimizedCallTarget callTarget = (OptimizedCallTarget)dependency.getCompilable();
                    if (callTarget != null) {
                        engineOptions = callTarget.getOptionValues();
                        logger = callTarget.engine.getEngineLogger();
                    } else {
                        EngineData engineData = OptimizedTVMCI.getEngineData(null);
                        engineOptions = engineData.engineOptions;
                        logger = engineData.getEngineLogger();
                    }
                }
                if (engineOptions.get(OptimizedRuntimeOptions.TraceAssumptions).booleanValue()) {
                    logStackTrace = true;
                    this.logInvalidatedDependency(dependency, message, logger);
                }
            }
            e2 = e2.next;
        }
        this.dependencies = null;
        this.size = 0;
        this.sizeAfterLastRemove = 0;
        this.isValid = false;
        if (logStackTrace) {
            OptimizedAssumption.logStackTrace(engineOptions, logger);
        }
    }

    private void removeDeadEntries() {
        Entry last = null;
        Entry e2 = this.dependencies;
        this.dependencies = null;
        while (e2 != null) {
            if (e2.isAlive()) {
                if (last == null) {
                    this.dependencies = e2;
                } else {
                    last.next = e2;
                }
                last = e2;
            } else {
                --this.size;
            }
            e2 = e2.next;
        }
        if (last != null) {
            last.next = null;
        }
        this.sizeAfterLastRemove = this.size;
    }

    public synchronized void removeDeadDependencies() {
        this.removeDeadEntries();
    }

    public synchronized int countDependencies() {
        return this.size;
    }

    public synchronized Consumer<OptimizedAssumptionDependency> registerDependency() {
        if (this.isValid) {
            if (this.name == Lazy.ALWAYS_VALID_NAME) {
                return DISCARD_DEPENDENCY;
            }
            if (this.size >= 2 * this.sizeAfterLastRemove) {
                this.removeDeadEntries();
            }
            Entry e2 = new Entry();
            e2.next = this.dependencies;
            this.dependencies = e2;
            ++this.size;
            return e2;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    private void logInvalidatedDependency(OptimizedAssumptionDependency dependency, String message, TruffleLogger logger) {
        StringBuilder sb = new StringBuilder("assumption '").append(this.name).append("' invalidated installed code '").append(dependency);
        if (message != null && !message.isEmpty()) {
            sb.append("' with message '").append(message);
        }
        logger.log(Level.INFO, sb.append("'").toString());
    }

    private static void logStackTrace(OptionValues engineOptions, TruffleLogger logger) {
        boolean skip = true;
        int limit = engineOptions.get(OptimizedRuntimeOptions.TraceStackTraceLimit);
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StringBuilder strb = new StringBuilder();
        String sep = "";
        for (int i2 = 1; i2 < stackTrace.length && i2 < 1 + limit; ++i2) {
            strb.append(sep).append("  ").append(stackTrace[i2].toString());
            sep = "\n";
        }
        if (stackTrace.length > 1 + limit) {
            strb.append("\n    ...");
        }
        logger.log(Level.INFO, strb.toString());
    }

    static class Lazy {
        static final Object ALWAYS_VALID_NAME = new Object(){

            public String toString() {
                return "<always valid>";
            }
        };

        Lazy() {
        }
    }

    static class Entry
    implements Consumer<OptimizedAssumptionDependency> {
        OptimizedAssumptionDependency dependency;
        boolean pending = true;
        Entry next;

        Entry() {
        }

        @Override
        public synchronized void accept(OptimizedAssumptionDependency dep) {
            this.dependency = dep;
            this.pending = false;
            this.notifyAll();
        }

        synchronized OptimizedAssumptionDependency awaitDependency() {
            boolean interrupted = false;
            while (this.pending) {
                try {
                    this.wait();
                }
                catch (InterruptedException e2) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return this.dependency;
        }

        synchronized boolean isAlive() {
            if (this.dependency == null) {
                return this.pending;
            }
            return this.dependency.isAlive();
        }

        public synchronized String toString() {
            if (this.dependency != null) {
                return String.format("%x[%s]", this.hashCode(), this.dependency);
            }
            return String.format("%x", this.hashCode());
        }
    }

    private static final class LazyReason
    implements CharSequence {
        private final String assumptionName;
        private final String message;
        private String strValue;

        LazyReason(String assumptionName, String message) {
            this.assumptionName = assumptionName;
            this.message = message;
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        @Override
        public String toString() {
            if (this.strValue == null) {
                this.strValue = this.assumptionName + " " + this.message;
            }
            return this.strValue;
        }
    }
}

