/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.IsolateSourceCache;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectCleaner;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

abstract class NativeIsolateSourceCache
extends NativeObject
implements IsolateSourceCache {
    private final Map<Object, Long> sourceHandles = Collections.synchronizedMap(new WeakHashMap());

    NativeIsolateSourceCache(NativeIsolate nativeIsolate, long l2) {
        super(nativeIsolate, l2);
    }

    static boolean isSourceRemotelyCacheable(Object object, AbstractPolyglotImpl.APIAccess aPIAccess) {
        Object object2 = aPIAccess.getSourceReceiver(object);
        AbstractPolyglotImpl.AbstractSourceDispatch abstractSourceDispatch = aPIAccess.getSourceDispatch(object);
        return !(object2 instanceof NativeObject) && abstractSourceDispatch.isCached(object2);
    }

    @Override
    public final long translate(Object object2) {
        AbstractPolyglotImpl.APIAccess aPIAccess = EnterprisePolyglotImpl.instance.getAPIAccess();
        if (NativeIsolateSourceCache.isSourceRemotelyCacheable(object2, aPIAccess)) {
            return this.sourceHandles.computeIfAbsent(object2, object -> {
                final long l2 = this.translateImpl(object);
                Object object2 = aPIAccess.getSourceReceiver(object);
                new NativeObjectCleaner<Object>(this, object2, this.getIsolate()){
                    final /* synthetic */ NativeIsolateSourceCache this$0;
                    {
                        this.this$0 = nativeIsolateSourceCache;
                        super(object, nativeIsolate);
                    }

                    @Override
                    protected void cleanUp(long l22) {
                        this.this$0.release(l2);
                    }
                }.register();
                return l2;
            });
        }
        return this.translateImpl(object2);
    }

    abstract long translateImpl(Object var1);

    @Override
    public final Object unhand(long l2) {
        throw new UnsupportedOperationException("Not supported on host.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Object> getCachedSources() {
        Map<Object, Long> map = this.sourceHandles;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet<Object>(this.sourceHandles.keySet()));
        }
    }
}

