/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.PolyglotIsolate;
import java.util.TooManyListenersException;
import java.util.concurrent.atomic.AtomicReference;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.HSObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;

class HSPolyglotObject
extends HSObject
implements PolyglotIsolate.TearDownHook {
    private final AtomicReference<TearDownListener> tearDownListener = new AtomicReference();

    HSPolyglotObject(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        super(jNIEnv, jObject, true, false);
        PolyglotIsolate.registerTearDownHook(10, this);
    }

    protected final void addTearDownListener(TearDownListener tearDownListener) throws TooManyListenersException {
        if (!this.tearDownListener.compareAndSet(null, tearDownListener)) {
            throw new TooManyListenersException();
        }
    }

    @Override
    public final void tearDown(JNI.JNIEnv jNIEnv) {
        TearDownListener tearDownListener = this.tearDownListener.get();
        if (tearDownListener != null) {
            tearDownListener.beforeTearDown(jNIEnv);
        }
        this.release(jNIEnv);
        if (tearDownListener != null) {
            tearDownListener.afterTearDown(jNIEnv);
        }
    }

    static interface TearDownListener {
        public void beforeTearDown(JNI.JNIEnv var1);

        public void afterTearDown(JNI.JNIEnv var1);
    }
}

