/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.objects.JSClassObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSShape;

@ExportLibrary(value=InteropLibrary.class)
public abstract class JSNonProxyObject
extends JSClassObject {
    protected JSNonProxyObject(Shape shape, JSDynamicObject proto) {
        super(shape, proto);
    }

    @ExportMessage
    public final boolean hasMetaObject() {
        return this.getMetaObjectImpl() != null;
    }

    @ExportMessage
    public final Object getMetaObject() throws UnsupportedMessageException {
        Object metaObject = this.getMetaObjectImpl();
        if (metaObject != null) {
            return metaObject;
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    public final Object getMetaObjectImpl() {
        assert (!JSGuards.isJSProxy(this));
        Object metaObject = JSRuntime.getDataProperty(this, JSObject.CONSTRUCTOR);
        if (metaObject != null && metaObject instanceof JSFunctionObject && ((JSFunctionObject)metaObject).isMetaInstance(this)) {
            return metaObject;
        }
        return null;
    }

    @Override
    public final boolean isExtensible() {
        return JSNonProxy.ordinaryIsExtensible(this);
    }

    @Override
    public boolean preventExtensions(boolean doThrow) {
        return JSNonProxy.ordinaryPreventExtensions(this, 0);
    }

    @Override
    public boolean testIntegrityLevel(boolean frozen) {
        if (JSShape.usesOrdinaryGetOwnProperty(this.getShape())) {
            return JSNonProxy.testIntegrityLevelFast(this, frozen);
        }
        return super.testIntegrityLevel(frozen);
    }

    @Override
    public boolean setIntegrityLevel(boolean freeze, boolean doThrow) {
        if (JSShape.usesOrdinaryGetOwnProperty(this.getShape())) {
            return JSNonProxy.setIntegrityLevelFast(this, freeze);
        }
        return super.setIntegrityLevel(freeze, doThrow);
    }

    @Override
    public TruffleString getClassName() {
        return Strings.UC_OBJECT;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return this.defaultToString();
        }
        return JSRuntime.objectToDisplayString(this, allowSideEffects, format, depth, this.getClassName());
    }
}

