/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerWithoutRoundingNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.util.TemporalConstants;

@ImportStatic(value={TemporalConstants.class})
public abstract class ToTemporalPartialDurationRecordNode
extends JavaScriptBaseNode {
    protected ToTemporalPartialDurationRecordNode() {
    }

    public abstract JSTemporalDurationRecord execute(Object var1, JSTemporalDurationRecord var2);

    @Specialization
    protected final JSTemporalDurationRecord toTemporalPartialDurationRecord(Object temporalDurationLike, JSTemporalDurationRecord defaults, @Cached IsObjectNode isObjectNode, @Cached InlinedBranchProfile errorBranch, @Cached JSToIntegerWithoutRoundingNode toIntegerIfIntegral, @Cached(value="create(DAYS, getJSContext())") PropertyGetNode getDays, @Cached(value="create(HOURS, getJSContext())") PropertyGetNode getHours, @Cached(value="create(MICROSECONDS, getJSContext())") PropertyGetNode getMicroseconds, @Cached(value="create(MILLISECONDS, getJSContext())") PropertyGetNode getMilliseconds, @Cached(value="create(MINUTES, getJSContext())") PropertyGetNode getMinutes, @Cached(value="create(MONTHS, getJSContext())") PropertyGetNode getMonths, @Cached(value="create(NANOSECONDS, getJSContext())") PropertyGetNode getNanoseconds, @Cached(value="create(SECONDS, getJSContext())") PropertyGetNode getSeconds, @Cached(value="create(WEEKS, getJSContext())") PropertyGetNode getWeeks, @Cached(value="create(YEARS, getJSContext())") PropertyGetNode getYears) {
        double years;
        if (!isObjectNode.executeBoolean(temporalDurationLike)) {
            errorBranch.enter(this);
            throw Errors.createTypeError("Given duration like is not a object.");
        }
        Object daysValue = getDays.getValue(temporalDurationLike);
        double days = JSGuards.isUndefined(daysValue) ? defaults.getDays() : toIntegerIfIntegral.executeDouble(daysValue);
        Object hoursValue = getHours.getValue(temporalDurationLike);
        double hours = JSGuards.isUndefined(hoursValue) ? defaults.getHours() : toIntegerIfIntegral.executeDouble(hoursValue);
        Object microsecondsValue = getMicroseconds.getValue(temporalDurationLike);
        double microseconds = JSGuards.isUndefined(microsecondsValue) ? defaults.getMicroseconds() : toIntegerIfIntegral.executeDouble(microsecondsValue);
        Object millisecondsValue = getMilliseconds.getValue(temporalDurationLike);
        double milliseconds = JSGuards.isUndefined(millisecondsValue) ? defaults.getMilliseconds() : toIntegerIfIntegral.executeDouble(millisecondsValue);
        Object minutesValue = getMinutes.getValue(temporalDurationLike);
        double minutes = JSGuards.isUndefined(minutesValue) ? defaults.getMinutes() : toIntegerIfIntegral.executeDouble(minutesValue);
        Object monthsValue = getMonths.getValue(temporalDurationLike);
        double months = JSGuards.isUndefined(monthsValue) ? defaults.getMonths() : toIntegerIfIntegral.executeDouble(monthsValue);
        Object nanosecondsValue = getNanoseconds.getValue(temporalDurationLike);
        double nanoseconds = JSGuards.isUndefined(nanosecondsValue) ? defaults.getNanoseconds() : toIntegerIfIntegral.executeDouble(nanosecondsValue);
        Object secondsValue = getSeconds.getValue(temporalDurationLike);
        double seconds = JSGuards.isUndefined(secondsValue) ? defaults.getSeconds() : toIntegerIfIntegral.executeDouble(secondsValue);
        Object weeksValue = getWeeks.getValue(temporalDurationLike);
        double weeks = JSGuards.isUndefined(weeksValue) ? defaults.getWeeks() : toIntegerIfIntegral.executeDouble(weeksValue);
        Object yearsValue = getYears.getValue(temporalDurationLike);
        double d2 = years = JSGuards.isUndefined(yearsValue) ? defaults.getYears() : toIntegerIfIntegral.executeDouble(yearsValue);
        if (JSGuards.isUndefined(yearsValue) && JSGuards.isUndefined(monthsValue) && JSGuards.isUndefined(weeksValue) && JSGuards.isUndefined(daysValue) && JSGuards.isUndefined(hoursValue) && JSGuards.isUndefined(minutesValue) && JSGuards.isUndefined(secondsValue) && JSGuards.isUndefined(millisecondsValue) && JSGuards.isUndefined(microsecondsValue) && JSGuards.isUndefined(nanosecondsValue)) {
            errorBranch.enter(this);
            throw Errors.createTypeError("Given duration like object has no duration properties.");
        }
        return JSTemporalDurationRecord.createWeeks(years, months, weeks, days, hours, minutes, seconds, milliseconds, microseconds, nanoseconds);
    }
}

