/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.texture;

import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.util.texture.IsOurTexture;
import com.ldtteam.blockui.util.texture.SpriteTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.fml.loading.FMLEnvironment;

public class OutOfJarTexture
extends AbstractTexture {
    protected final OutOfJarResourceLocation resourceLocation;
    private boolean redirectToSprite = false;

    public OutOfJarTexture(OutOfJarResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void load(ResourceManager resourceManager) throws IOException {
        NativeImage nativeImage;
        Resource resource = OutOfJarResourceLocation.getResourceHandle(this.resourceLocation, resourceManager);
        if (resource.metadata().getSection((MetadataSectionSerializer)AnimationMetadataSection.SERIALIZER).isPresent()) {
            this.redirectToSprite = true;
            throw new IOException("Vanilla hack: redirecting loading to sprite texture, do NOT report this exception, it IS intended");
        }
        TextureMetadataSection textureMeta = resource.metadata().getSection((MetadataSectionSerializer)TextureMetadataSection.SERIALIZER).orElse(null);
        try (InputStream is = resource.open();){
            nativeImage = NativeImage.read((InputStream)is);
        }
        TextureUtil.prepareImage((int)this.getId(), (int)0, (int)nativeImage.getWidth(), (int)nativeImage.getHeight());
        if (textureMeta != null) {
            nativeImage.upload(0, 0, 0, 0, 0, nativeImage.getWidth(), nativeImage.getHeight(), textureMeta.isBlur(), textureMeta.isClamp(), false, true);
        } else {
            nativeImage.upload(0, 0, 0, true);
        }
    }

    public static AbstractTexture assertLoadedDefaultManagers(ResourceLocation resLoc) {
        return OutOfJarTexture.assertLoaded(resLoc, Minecraft.getInstance().getTextureManager(), Minecraft.getInstance().getResourceManager());
    }

    public static AbstractTexture assertLoaded(ResourceLocation resLoc, TextureManager textureManager, ResourceManager resourceManager) {
        if (!(resLoc instanceof OutOfJarResourceLocation)) {
            return textureManager.getTexture(resLoc);
        }
        OutOfJarResourceLocation outOfJarResLoc = (OutOfJarResourceLocation)resLoc;
        AbstractTexture current = textureManager.getTexture(resLoc, null);
        if (IsOurTexture.isOur(current)) {
            return current;
        }
        if (current == MissingTextureAtlasSprite.getTexture()) {
            if (!FMLEnvironment.production && !resLoc.getNamespace().equals("blockui")) {
                throw new IllegalArgumentException("Missing texture: " + String.valueOf(resLoc));
            }
            return current;
        }
        OutOfJarTexture outOfJarTexture = new OutOfJarTexture(outOfJarResLoc);
        textureManager.register((ResourceLocation)outOfJarResLoc, (AbstractTexture)outOfJarTexture);
        if (outOfJarTexture.redirectToSprite) {
            textureManager.register((ResourceLocation)outOfJarResLoc, (AbstractTexture)new SpriteTexture(outOfJarResLoc));
        }
        return OutOfJarTexture.assertLoaded(outOfJarResLoc, textureManager, resourceManager);
    }
}

