/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.AtlasManager;
import com.ldtteam.blockui.BOGuiGraphics;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.UiRenderMacros;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.util.records.SizeI;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.util.texture.OutOfJarTexture;
import com.ldtteam.blockui.util.texture.SpriteTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLEnvironment;

public class Image
extends Pane {
    protected ResourceLocation resourceLocation = null;
    protected int u = 0;
    protected int v = 0;
    protected int uWidth = 0;
    protected int vHeight = 0;
    protected UiRenderMacros.ResolvedBlit resolvedBlit = null;

    public Image() {
    }

    public Image(PaneParams params) {
        super(params);
        params.applyShorthand("imageoffset", Parsers.INT, 2, a -> {
            this.u = (Integer)a.get(0);
            this.v = (Integer)a.get(1);
        });
        params.applyShorthand("imagesize", Parsers.INT, 2, a -> {
            this.uWidth = (Integer)a.get(0);
            this.vHeight = (Integer)a.get(1);
        });
        this.resourceLocation = params.getResource("source");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static SizeI getImageDimensions(ResourceLocation resourceLocation) {
        OutOfJarTexture.assertLoadedDefaultManagers(resourceLocation);
        int pos = resourceLocation.getPath().lastIndexOf(".");
        if (pos == -1) {
            try (InputStream is = OutOfJarResourceLocation.openStream(resourceLocation, Minecraft.getInstance().getResourceManager());){
                SizeI sizeI;
                block36: {
                    NativeImage nativeImage = NativeImage.read((InputStream)is);
                    try {
                        sizeI = new SizeI(nativeImage.getWidth(), nativeImage.getHeight());
                        if (nativeImage == null) break block36;
                    }
                    catch (Throwable throwable) {
                        if (nativeImage != null) {
                            try {
                                nativeImage.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    nativeImage.close();
                }
                return sizeI;
            }
            catch (Exception e) {
                throw new IllegalStateException("No extension for file: " + resourceLocation.toString(), e);
            }
        }
        String suffix = resourceLocation.getPath().substring(pos + 1);
        Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(suffix);
        while (it.hasNext()) {
            ImageReader reader = it.next();
            try {
                SizeI sizeI;
                ImageInputStream stream;
                InputStream is2;
                block38: {
                    block37: {
                        is2 = OutOfJarResourceLocation.openStream(resourceLocation, Minecraft.getInstance().getResourceManager());
                        stream = ImageIO.createImageInputStream(is2);
                        reader.setInput(stream);
                        sizeI = new SizeI(reader.getWidth(reader.getMinIndex()), reader.getHeight(reader.getMinIndex()));
                        if (stream == null) break block37;
                        stream.close();
                    }
                    if (is2 == null) break block38;
                    is2.close();
                }
                return sizeI;
                {
                    catch (Throwable throwable) {
                        try {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Throwable throwable4) {
                                if (is2 != null) {
                                    try {
                                        is2.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable4.addSuppressed(throwable5);
                                    }
                                }
                                throw throwable4;
                            }
                        }
                        catch (FileNotFoundException | NoSuchFileException is2) {
                            reader.dispose();
                        }
                        catch (IOException e) {
                            Log.getLogger().warn((Object)e);
                        }
                    }
                }
            }
            finally {
                reader.dispose();
            }
        }
        if (!FMLEnvironment.production) {
            throw new RuntimeException("Couldn't resolve size for image: " + String.valueOf(resourceLocation));
        }
        return new SizeI(0, 0);
    }

    public void setImage(ResourceLocation rl, int u, int v, int uWidth, int vHeight) {
        if (Objects.equals(rl, this.resourceLocation) && this.u == u && this.v == v && this.uWidth == uWidth && this.vHeight == vHeight) {
            return;
        }
        this.resourceLocation = rl;
        this.u = u;
        this.v = v;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
        this.resolvedBlit = null;
    }

    public void setImage(ResourceLocation rl, boolean keepUv) {
        if (keepUv) {
            this.setImage(rl, this.u, this.v, this.uWidth, this.vHeight);
        } else {
            this.setImage(rl, 0, 0, 0, 0);
        }
    }

    @Override
    public void drawSelf(BOGuiGraphics target, double mx, double my) {
        if (!FMLEnvironment.production) {
            Objects.requireNonNull(this.resourceLocation, () -> "Missing image source: " + this.id + " | " + String.valueOf(this.window.getXmlResourceLocation()));
        }
        if (this.resolvedBlit == null) {
            this.resolvedBlit = Image.resolveBlit(this.resourceLocation, this.u, this.v, this.uWidth, this.vHeight);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.resolvedBlit.blit(target.pose(), this.x, this.y, this.width, this.height);
        RenderSystem.disableBlend();
    }

    public static UiRenderMacros.ResolvedBlit resolveBlit(ResourceLocation resLoc) {
        return Image.resolveBlit(resLoc, 0, 0, 0, 0);
    }

    public static UiRenderMacros.ResolvedBlit resolveBlit(ResourceLocation resLoc, int u, int v, int uWidth, int vHeight) {
        if (resLoc == null || resLoc == MissingTextureAtlasSprite.getLocation()) {
            return (ps, x, y, w, h) -> Image.blit(ps, MissingTextureAtlasSprite.getLocation(), x, y, w, h);
        }
        TextureAtlasSprite atlasSprite = AtlasManager.INSTANCE.getSprite(resLoc);
        if (atlasSprite.contents().name() != MissingTextureAtlasSprite.getLocation()) {
            return Image.resolveSprite(atlasSprite, AtlasManager.getSpriteScaling(atlasSprite));
        }
        AbstractTexture texture = OutOfJarTexture.assertLoadedDefaultManagers(resLoc);
        if (texture instanceof SpriteTexture || u == 0 && v == 0 && uWidth == 0 && vHeight == 0) {
            ResourceLocation notBugged = texture == null ? MissingTextureAtlasSprite.getLocation() : resLoc;
            return (ps, x, y, w, h) -> Image.blit(ps, notBugged, x, y, w, h);
        }
        SizeI mapSize = Image.getImageDimensions(resLoc);
        float uMin = (float)u / (float)mapSize.width();
        float uMax = uWidth == 0 ? 1.0f : uMin + (float)uWidth / (float)mapSize.width();
        float vMin = (float)v / (float)mapSize.height();
        float vMax = vHeight == 0 ? 1.0f : vMin + (float)vHeight / (float)mapSize.height();
        return (ps, x, y, w, h) -> Image.blit(ps, resLoc, x, y, uWidth, vHeight, uMin, vMin, uMax, vMax);
    }
}

