/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.loading.FMLEnvironment;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class UiRenderMacros {
    public static final double HALF_BIAS = 0.5;

    public static void drawLineRectGradient(PoseStack ps, int x, int y, int w, int h, int argbColorStart, int argbColorEnd) {
        UiRenderMacros.drawLineRectGradient(ps, x, y, w, h, argbColorStart, argbColorEnd, 1);
    }

    public static void drawLineRectGradient(PoseStack ps, int x, int y, int w, int h, int argbColorStart, int argbColorEnd, int lineWidth) {
        UiRenderMacros.drawLineRectGradient(ps, x, y, w, h, argbColorStart >> 16 & 0xFF, argbColorEnd >> 16 & 0xFF, argbColorStart >> 8 & 0xFF, argbColorEnd >> 8 & 0xFF, argbColorStart & 0xFF, argbColorEnd & 0xFF, argbColorStart >> 24 & 0xFF, argbColorEnd >> 24 & 0xFF, lineWidth);
    }

    public static void drawLineRectGradient(PoseStack ps, int x, int y, int w, int h, int redStart, int redEnd, int greenStart, int greenEnd, int blueStart, int blueEnd, int alphaStart, int alphaEnd, int lineWidth) {
        if (lineWidth < 1 || alphaStart == 0 && alphaEnd == 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (alphaStart != 255 || alphaEnd != 255) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        Matrix4f m = ps.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        buffer.addVertex(m, (float)(x + lineWidth), (float)(y + h - lineWidth), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        buffer.addVertex(m, (float)(x + lineWidth), (float)(y + lineWidth), 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        buffer.addVertex(m, (float)(x + w - lineWidth), (float)(y + lineWidth), 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        buffer.addVertex(m, (float)(x + w - lineWidth), (float)(y + lineWidth), 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        buffer.addVertex(m, (float)(x + w - lineWidth), (float)(y + h - lineWidth), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        buffer.addVertex(m, (float)(x + lineWidth), (float)(y + h - lineWidth), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        RenderSystem.disableBlend();
    }

    public static void drawLineRect(PoseStack ps, int x, int y, int w, int h, int argbColor) {
        UiRenderMacros.drawLineRect(ps, x, y, w, h, argbColor, 1);
    }

    public static void drawLineRect(PoseStack ps, int x, int y, int w, int h, int argbColor, int lineWidth) {
        UiRenderMacros.drawLineRect(ps, x, y, w, h, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF, lineWidth);
    }

    public static void drawLineRect(PoseStack ps, int x, int y, int w, int h, int red, int green, int blue, int alpha, int lineWidth) {
        if (lineWidth < 1 || alpha == 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (alpha != 255) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        Matrix4f m = ps.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + lineWidth), (float)(y + h - lineWidth), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + lineWidth), (float)(y + lineWidth), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w - lineWidth), (float)(y + lineWidth), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w - lineWidth), (float)(y + lineWidth), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w - lineWidth), (float)(y + h - lineWidth), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + lineWidth), (float)(y + h - lineWidth), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        RenderSystem.disableBlend();
    }

    public static void fill(PoseStack ps, int x, int y, int w, int h, int argbColor) {
        UiRenderMacros.fill(ps, x, y, w, h, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF);
    }

    public static void fill(PoseStack ps, int x, int y, int w, int h, int red, int green, int blue, int alpha) {
        if (alpha == 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (alpha != 255) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        Matrix4f m = ps.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        RenderSystem.disableBlend();
    }

    public static void fillGradient(PoseStack ps, int x, int y, int w, int h, int argbColorStart, int argbColorEnd) {
        UiRenderMacros.fillGradient(ps, x, y, w, h, argbColorStart >> 16 & 0xFF, argbColorEnd >> 16 & 0xFF, argbColorStart >> 8 & 0xFF, argbColorEnd >> 8 & 0xFF, argbColorStart & 0xFF, argbColorEnd & 0xFF, argbColorStart >> 24 & 0xFF, argbColorEnd >> 24 & 0xFF);
    }

    public static void fillGradient(PoseStack ps, int x, int y, int w, int h, int redStart, int redEnd, int greenStart, int greenEnd, int blueStart, int blueEnd, int alphaStart, int alphaEnd) {
        if (alphaStart == 0 && alphaEnd == 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (alphaStart != 255 || alphaEnd != 255) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        Matrix4f m = ps.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        RenderSystem.disableBlend();
    }

    public static void hLine(PoseStack ps, int x, int xEnd, int y, int argbColor) {
        UiRenderMacros.line(ps, x, y, xEnd, y, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF);
    }

    public static void hLine(PoseStack ps, int x, int xEnd, int y, int red, int green, int blue, int alpha) {
        UiRenderMacros.line(ps, x, y, xEnd, y, red, green, blue, alpha);
    }

    public static void vLine(PoseStack ps, int x, int y, int yEnd, int argbColor) {
        UiRenderMacros.line(ps, x, y, x, yEnd, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF);
    }

    public static void vLine(PoseStack ps, int x, int y, int yEnd, int red, int green, int blue, int alpha) {
        UiRenderMacros.line(ps, x, y, x, yEnd, red, green, blue, alpha);
    }

    public static void line(PoseStack ps, int x, int y, int xEnd, int yEnd, int argbColor) {
        UiRenderMacros.line(ps, x, y, xEnd, yEnd, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF);
    }

    public static void line(PoseStack ps, int x, int y, int xEnd, int yEnd, int red, int green, int blue, int alpha) {
        if (alpha == 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (alpha != 255) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        Matrix4f m = ps.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)xEnd, (float)yEnd, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        RenderSystem.disableBlend();
    }

    public static void blit(PoseStack ps, ResourceLocation rl, int x, int y, int w, int h, int u, int v, int mapW, int mapH) {
        UiRenderMacros.blit(ps, rl, x, y, w, h, (float)u / (float)mapW, (float)v / (float)mapH, (float)(u + w) / (float)mapW, (float)(v + h) / (float)mapH);
    }

    public static void blit(PoseStack ps, ResourceLocation rl, int x, int y, int w, int h, int u, int v, int uW, int vH, int mapW, int mapH) {
        UiRenderMacros.blit(ps, rl, x, y, w, h, (float)u / (float)mapW, (float)v / (float)mapH, (float)(u + uW) / (float)mapW, (float)(v + vH) / (float)mapH);
    }

    public static void blitSprite(PoseStack ps, TextureAtlasSprite sprite, GuiSpriteScaling guiScaling, int x, int y, int w, int h) {
        ResourceLocation atlasLocation = sprite.atlasLocation();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        if (guiScaling.type() == GuiSpriteScaling.Type.STRETCH) {
            UiRenderMacros.blit(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1);
        } else if (guiScaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)guiScaling;
            int rbW = nineSlice.width();
            int rbH = nineSlice.height();
            if (rbW == w && rbH == h) {
                UiRenderMacros.blit(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1);
            } else {
                int uR = nineSlice.border().left();
                int vR = nineSlice.border().top();
                int rW = rbW - uR - nineSlice.border().right();
                int rH = rbH - vR - nineSlice.border().bottom();
                UiRenderMacros.blitRepeatable(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1, uR, vR, rW, rH, rbW, rbH);
            }
        } else if (guiScaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)guiScaling;
            int tW = tile.width();
            int tH = tile.height();
            if (tW == w && tH == h) {
                UiRenderMacros.blit(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1);
            } else {
                UiRenderMacros.blitRepeatable(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1, 0, 0, tW, tH, tW, tH);
            }
        }
    }

    public static void blitSprite(PoseStack ps, TextureAtlasSprite sprite, int x, int y, int w, int h) {
        UiRenderMacros.blit(ps, sprite.atlasLocation(), x, y, w, h, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1());
    }

    public static void blit(PoseStack ps, ResourceLocation rl, int x, int y, int w, int h) {
        UiRenderMacros.blit(ps, rl, x, y, w, h, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blit(PoseStack ps, ResourceLocation rl, int x, int y, int w, int h, float uMin, float vMin, float uMax, float vMax) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)rl);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f m = ps.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setUv(uMin, vMin);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setUv(uMin, vMax);
        buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setUv(uMax, vMax);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setUv(uMax, vMin);
        BufferUploader.drawWithShader((MeshData)buffer.build());
    }

    protected static void blitRepeatable(PoseStack ps, ResourceLocation rl, int x, int y, int width, int height, float uMin, float vMin, float uMax, float vMax, int uRepeat, int vRepeat, int repeatWidth, int repeatHeight, int repeatBoxWidth, int repeatBoxHeight) {
        float maxV;
        float minV;
        int h;
        int yStart;
        int vAdjust;
        int j;
        if (uRepeat < 0 || vRepeat < 0 || uRepeat >= repeatBoxWidth || vRepeat >= repeatBoxHeight || repeatWidth < 1 || repeatHeight < 1 || repeatWidth > repeatBoxWidth - uRepeat || repeatHeight > repeatBoxHeight - vRepeat) {
            throw new IllegalArgumentException("Repeatable box is outside of texture box");
        }
        int repeatCountX = Math.max(1, Math.max(0, width - (repeatBoxWidth - repeatWidth)) / repeatWidth);
        int repeatCountY = Math.max(1, Math.max(0, height - (repeatBoxHeight - repeatHeight)) / repeatHeight);
        float uTexelWidth = (uMax - uMin) / (float)repeatBoxWidth;
        float vTexelHeight = (vMax - vMin) / (float)repeatBoxHeight;
        Matrix4f mat = ps.last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i < repeatCountX; ++i) {
            int uAdjust = i == 0 ? 0 : uRepeat;
            int xStart = x + uAdjust + i * repeatWidth;
            int w = Math.min(repeatWidth + uRepeat - uAdjust, width - (repeatBoxWidth - uRepeat - repeatWidth));
            float minU = uMin + uTexelWidth * (float)uAdjust;
            float maxU = minU + uTexelWidth * (float)w;
            for (j = 0; j < repeatCountY; ++j) {
                vAdjust = j == 0 ? 0 : vRepeat;
                yStart = y + vAdjust + j * repeatHeight;
                h = Math.min(repeatHeight + vRepeat - vAdjust, height - (repeatBoxHeight - vRepeat - repeatHeight));
                minV = vMin + vTexelHeight * (float)vAdjust;
                maxV = minV + vTexelHeight * (float)h;
                UiRenderMacros.populateBlitTriangles(buffer, mat, xStart, xStart + w, yStart, yStart + h, minU, maxU, minV, maxV);
            }
        }
        int xEnd = x + Math.min(uRepeat + repeatCountX * repeatWidth, width - (repeatBoxWidth - uRepeat - repeatWidth));
        int yEnd = y + Math.min(vRepeat + repeatCountY * repeatHeight, height - (repeatBoxHeight - vRepeat - repeatHeight));
        int uLeft = width - (xEnd - x);
        int vBot = height - (yEnd - y);
        float restMinU = uMax - (float)uLeft * uTexelWidth;
        float restMinV = vMax - (float)vBot * vTexelHeight;
        for (int i = 0; i < repeatCountX; ++i) {
            int uAdjust = i == 0 ? 0 : uRepeat;
            int xStart = x + uAdjust + i * repeatWidth;
            int w = Math.min(repeatWidth + uRepeat - uAdjust, width - uLeft);
            float minU = uMin + uTexelWidth * (float)uAdjust;
            float maxU = minU + uTexelWidth * (float)w;
            UiRenderMacros.populateBlitTriangles(buffer, mat, xStart, xStart + w, yEnd, yEnd + vBot, minU, maxU, restMinV, vMax);
        }
        for (j = 0; j < repeatCountY; ++j) {
            vAdjust = j == 0 ? 0 : vRepeat;
            yStart = y + vAdjust + j * repeatHeight;
            h = Math.min(repeatHeight + vRepeat - vAdjust, height - vBot);
            minV = vMin + vTexelHeight * (float)vAdjust;
            maxV = minV + vTexelHeight * (float)h;
            UiRenderMacros.populateBlitTriangles(buffer, mat, xEnd, xEnd + uLeft, yStart, yStart + h, restMinU, uMax, minV, maxV);
        }
        UiRenderMacros.populateBlitTriangles(buffer, mat, xEnd, xEnd + uLeft, yEnd, yEnd + vBot, restMinU, uMax, restMinV, vMax);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)rl);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferUploader.drawWithShader((MeshData)buffer.build());
    }

    public static void populateFillTriangles(Matrix4f m, BufferBuilder buffer, int x, int y, int w, int h, int red, int green, int blue, int alpha) {
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(red, green, blue, alpha);
    }

    public static void populateFillGradientTriangles(Matrix4f m, BufferBuilder buffer, int x, int y, int w, int h, int redStart, int redEnd, int greenStart, int greenEnd, int blueStart, int blueEnd, int alphaStart, int alphaEnd) {
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(redStart, greenStart, blueStart, alphaStart);
        buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
        buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(redEnd, greenEnd, blueEnd, alphaEnd);
    }

    public static void populateBlitTriangles(BufferBuilder buffer, Matrix4f mat, float xStart, float xEnd, float yStart, float yEnd, float uMin, float uMax, float vMin, float vMax) {
        buffer.addVertex(mat, xStart, yStart, 0.0f).setUv(uMin, vMin);
        buffer.addVertex(mat, xStart, yEnd, 0.0f).setUv(uMin, vMax);
        buffer.addVertex(mat, xEnd, yStart, 0.0f).setUv(uMax, vMin);
        buffer.addVertex(mat, xEnd, yStart, 0.0f).setUv(uMax, vMin);
        buffer.addVertex(mat, xStart, yEnd, 0.0f).setUv(uMin, vMax);
        buffer.addVertex(mat, xEnd, yEnd, 0.0f).setUv(uMax, vMax);
    }

    public static void drawEntity(PoseStack poseStack, int x, int y, double scale, float headYaw, float yaw, float pitch, Entity entity) {
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        Minecraft mc = Minecraft.getInstance();
        if (entity.level() == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 1050.0f);
        poseStack.scale(1.0f, 1.0f, -1.0f);
        poseStack.translate(0.0, 0.0, 1000.0);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        Quaternionf pitchRotation = Axis.XP.rotationDegrees(pitch);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(pitchRotation);
        float oldYaw = entity.getYRot();
        float oldPitch = entity.getXRot();
        float oldYawOffset = livingEntity == null ? 0.0f : livingEntity.yBodyRot;
        float oldPrevYawHead = livingEntity == null ? 0.0f : livingEntity.yHeadRotO;
        float oldYawHead = livingEntity == null ? 0.0f : livingEntity.yHeadRot;
        entity.setYRot(180.0f + headYaw);
        entity.setXRot(-pitch);
        if (livingEntity != null) {
            livingEntity.yBodyRot = 180.0f + yaw;
            livingEntity.yHeadRot = entity.getYRot();
            livingEntity.yHeadRotO = entity.getYRot();
        }
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher dispatcher = mc.getEntityRenderDispatcher();
        pitchRotation.conjugate();
        dispatcher.overrideCameraOrientation(pitchRotation);
        dispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource buffers = mc.renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> dispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)buffers, 0xF000F0));
        buffers.endBatch();
        dispatcher.setRenderShadow(true);
        entity.setYRot(oldYaw);
        entity.setXRot(oldPitch);
        if (livingEntity != null) {
            livingEntity.yBodyRot = oldYawOffset;
            livingEntity.yHeadRotO = oldPrevYawHead;
            livingEntity.yHeadRot = oldYawHead;
        }
        poseStack.popPose();
        Lighting.setupFor3DItems();
    }

    public static ResolvedBlit resolveSprite(TextureAtlasSprite sprite, GuiSpriteScaling guiScaling) {
        ResourceLocation atlasLocation = sprite.atlasLocation();
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        if (guiScaling.type() == GuiSpriteScaling.Type.STRETCH) {
            return (ps, x, y, w, h) -> UiRenderMacros.blit(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1);
        }
        if (guiScaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)guiScaling;
            int rbW = nineSlice.width();
            int rbH = nineSlice.height();
            int uR = nineSlice.border().left();
            int vR = nineSlice.border().top();
            int rW = rbW - uR - nineSlice.border().right();
            int rH = rbH - vR - nineSlice.border().bottom();
            return (ps, x, y, w, h) -> {
                if (rbW == w && rbH == h) {
                    UiRenderMacros.blit(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1);
                } else {
                    UiRenderMacros.blitRepeatable(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1, uR, vR, rW, rH, rbW, rbH);
                }
            };
        }
        if (guiScaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)guiScaling;
            int tW = tile.width();
            int tH = tile.height();
            return (ps, x, y, w, h) -> {
                if (tW == w && tH == h) {
                    UiRenderMacros.blit(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1);
                } else {
                    UiRenderMacros.blitRepeatable(ps, atlasLocation, x, y, w, h, u0, v0, u1, v1, 0, 0, tW, tH, tW, tH);
                }
            };
        }
        if (!FMLEnvironment.production) {
            throw new UnsupportedOperationException("Missing resolver for gui scaling: " + String.valueOf(guiScaling.type()));
        }
        return ResolvedBlit.EMPTY;
    }

    @FunctionalInterface
    public static interface ResolvedBlit {
        public static final ResolvedBlit EMPTY = (ps, x, y, w, h) -> {};

        public void blit(PoseStack var1, int var2, int var3, int var4, int var5);
    }
}

