/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.mod.item.BlockStateRenderingData;
import com.ldtteam.blockui.util.SingleBlockGetter;
import com.ldtteam.blockui.util.cursor.Cursor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class BOGuiGraphics
extends GuiGraphics {
    private static final SingleBlockGetter.SingleBlockNeighborhood NEIGHBORHOOD = new SingleBlockGetter.SingleBlockNeighborhood();
    private int cursorMaxDepth = -1;
    private Cursor selectedCursor = Cursor.DEFAULT;

    public BOGuiGraphics(Minecraft mc, PoseStack ps, MultiBufferSource.BufferSource buffers) {
        super(mc, ps, buffers);
    }

    private Font getFont(@Nullable ItemStack itemStack) {
        Font font;
        if (itemStack != null && (font = IClientItemExtensions.of((ItemStack)itemStack).getFont(itemStack, IClientItemExtensions.FontContext.ITEM_COUNT)) != null) {
            return font;
        }
        return this.minecraft.font;
    }

    public void renderItemDecorations(ItemStack itemStack, int x, int y) {
        super.renderItemDecorations(this.getFont(itemStack), itemStack, x, y);
    }

    public void renderItemDecorations(ItemStack itemStack, int x, int y, @Nullable String altStackSize) {
        super.renderItemDecorations(this.getFont(itemStack), itemStack, x, y, altStackSize);
    }

    public int drawString(String text, float x, float y, int color) {
        return this.drawString(text, x, y, color, false);
    }

    public int drawString(String text, float x, float y, int color, boolean shadow) {
        return super.drawString(this.minecraft.font, text, x, y, color, shadow);
    }

    public void setCursor(Cursor cursor) {
        if (this.pose().poseStack.size() >= this.cursorMaxDepth) {
            this.cursorMaxDepth = this.pose().poseStack.size();
            this.selectedCursor = cursor;
        }
    }

    public void applyCursor(int debugXoffset) {
        this.selectedCursor.apply();
        if (Pane.debugging) {
            String string = this.selectedCursor.toString();
            float f = debugXoffset;
            Objects.requireNonNull(this.minecraft.font);
            this.drawString(string, f, -9, Color.getByName("white"));
        }
    }

    public void renderBlockStateAsItem(BlockStateRenderingData data, ItemStack itemStack) {
        FluidState fluidState;
        BakedModel itemModel = this.minecraft.getItemRenderer().getModel(itemStack, null, null, 0);
        if (!itemModel.isGui3d() || data.blockState().getRenderShape() == RenderShape.INVISIBLE) {
            itemModel = this.minecraft.getItemRenderer().getModel(new ItemStack((ItemLike)Blocks.STONE), null, null, 0);
        }
        this.pose().pushPose();
        this.pose().last().normal().identity();
        this.pose().translate(8.0f, 8.0f, 150.0f);
        this.pose().scale(16.0f, -16.0f, 16.0f);
        ClientHooks.handleCameraTransforms((PoseStack)this.pose(), (BakedModel)itemModel, (ItemDisplayContext)ItemDisplayContext.GUI, (boolean)false);
        if (data.modelNeedsRotationFix()) {
            Matrix3f oldNormal = this.pose().last().normal();
            this.pose().pushPose();
            this.pose().rotateAround(Axis.YP.rotationDegrees(45.0f), 0.0f, 0.5f, 0.0f);
            this.pose().last().normal().set((Matrix3fc)oldNormal.rotate((Quaternionfc)Axis.YP.rotationDegrees(-45.0f)));
        }
        this.pose().translate(-0.5f, -0.5f, -0.5f);
        int light = LightTexture.pack((int)15, (int)15);
        this.minecraft.getBlockRenderer().renderSingleBlock(data.blockState(), this.pose(), (MultiBufferSource)this.bufferSource(), light, OverlayTexture.NO_OVERLAY, data.modelData(), null);
        if (data.blockEntity() != null) {
            try {
                this.minecraft.getBlockEntityRenderDispatcher().getRenderer(data.blockEntity()).render(data.blockEntity(), 0.0f, this.pose(), (MultiBufferSource)this.bufferSource(), light, OverlayTexture.NO_OVERLAY);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.flush();
        if (data.modelNeedsRotationFix()) {
            this.pose().popPose();
            this.pose().translate(-0.5f, -0.5f, -0.5f);
        }
        if (!(fluidState = data.blockState().getFluidState()).isEmpty()) {
            RenderType renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState);
            this.pushMvApplyPose();
            BOGuiGraphics.NEIGHBORHOOD.blockState = data.blockState();
            this.minecraft.getBlockRenderer().renderLiquid(BlockPos.ZERO, (BlockAndTintGetter)NEIGHBORHOOD, this.bufferSource().getBuffer(renderType), data.blockState(), fluidState);
            this.bufferSource().endBatch(renderType);
            this.popMvPose();
        }
        this.pose().popPose();
    }

    public void pushMvApplyPose() {
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().mul((Matrix4fc)this.pose().last().pose());
        RenderSystem.applyModelViewMatrix();
    }

    public void popMvPose() {
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public static double getAltSpeedFactor() {
        return Screen.hasAltDown() ? 5.0 : 1.0;
    }
}

