/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils;

import com.electronwill.nightconfig.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig {
    private ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private ModConfigSpec.BooleanValue enabled;
    private ModConfigSpec.IntValue timer;
    private ModConfigSpec.IntValue maximum;
    private ModConfigSpec.ConfigValue<String> warnings;
    private ModConfigSpec.BooleanValue title;
    private ModConfigSpec.ConfigValue<String> titletext;
    private ModConfigSpec.ConfigValue<String> warningtext;
    private ModConfigSpec.IntValue memoryLogTimer;
    private ModConfigSpec.IntValue memoryWarnDelta;
    private ModConfigSpec.IntValue memoryTimer;
    private ModConfigSpec.BooleanValue memoryChecker;
    private ModConfigSpec.BooleanValue heapDump;
    private ModConfigSpec.IntValue chunkExpire;
    private ModConfigSpec.BooleanValue shouldChunksExpire;

    ServerConfig() {
        this.builder.push("Item Clear");
        this.builder.comment("Check Every <timer>  minutes how many items are loaded. If there are more than <maximum>. Then Remove All Items. Configs are reloaded on worldreload and clear");
        this.enabled = this.builder.comment("Enable regular ItemClear").define("enabled", false);
        this.timer = this.builder.comment("Waiting time between Checks in Minutes").defineInRange("timer", 30, 0, 1440);
        this.maximum = this.builder.comment("Do a clear if there are more than X items").defineInRange("maximum", 1000, 0, Integer.MAX_VALUE);
        this.warnings = this.builder.comment("Chat warning, Comma separated, in seconds").define("warnings", (Object)"5,20");
        this.title = this.builder.comment("Run a Title command on first warning").define("title", true);
        this.titletext = this.builder.comment("Text to display in TitleCommand").define("titletext", (Object)"ITEMCLEAR INCOMING!");
        this.warningtext = this.builder.comment("Text to Display in Chat when Item. First % will be replaced by Value. In red, encased in [=== ").define("warningtext", (Object)"ITEMCLEAR IN % SECONDS");
        this.builder.pop();
        this.builder.push("Memory Checker");
        this.builder.comment("Adds a Memory checker that reads currently used Memory. A command that reads out the last logged memory values, and a warning in logs when large amounts of memory get used in a small amount of time");
        this.memoryChecker = this.builder.comment("Enable the Memory checker").define("enabled", false);
        this.memoryTimer = this.builder.comment("Check memory every (in seconds)").defineInRange("timer", 5, 0, Integer.MAX_VALUE);
        this.memoryLogTimer = this.builder.comment("Time between Memory Checks that will get saved for display(in seconds)").defineInRange("timer", 30, 0, Integer.MAX_VALUE);
        this.memoryWarnDelta = this.builder.comment("Threshold at which the Memory checker will display a warning in the Log (in MB)").defineInRange("threshold", 1000, 0, Integer.MAX_VALUE);
        this.heapDump = this.builder.comment("Run /spark heapdump when memory fills up more than 95 % the first time. This value gets set to false if this occurs").define("heapdump", false);
        this.builder.pop();
        this.builder.push("Ftb Chunks");
        this.shouldChunksExpire = this.builder.comment("If Ftb chunks is installed enable automatic purge of loaded chunks for people who have not been online for some amount of days. (Note LOADED not Claimed Chunks)").define("enabled", false);
        this.chunkExpire = this.builder.comment("Number of days after which a players chunks will be unloaded. Warning! This relies on the modify date of the player data file. ").defineInRange("days", 7, 0, Integer.MAX_VALUE);
        this.builder.pop();
    }

    public boolean getEnabled() {
        return (Boolean)this.enabled.get();
    }

    public int getTimer() {
        return (Integer)this.timer.get();
    }

    public int getMaximum() {
        return (Integer)this.maximum.get();
    }

    public List<Integer> getWarnings() {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        StringUtils.split((String)((String)this.warnings.get()), (char)',').forEach(x -> ints.add(Integer.parseInt(x)));
        return ints;
    }

    public boolean getTitle() {
        return (Boolean)this.title.get();
    }

    public ModConfigSpec getSpec() {
        return this.builder.build();
    }

    public String getWarningText() {
        return (String)this.warningtext.get();
    }

    public String getTitleText() {
        return (String)this.titletext.get();
    }

    public int getMemoryLogTimer() {
        return (Integer)this.memoryLogTimer.get();
    }

    public int getMemoryWarnDelta() {
        return (Integer)this.memoryWarnDelta.get();
    }

    public int getMemoryTimer() {
        return (Integer)this.memoryTimer.get();
    }

    public boolean getMemoryChecker() {
        return (Boolean)this.memoryChecker.get();
    }

    public boolean getHeapDump() {
        return (Boolean)this.heapDump.get();
    }

    public void disableHeapDump() {
        this.heapDump.set((Object)false);
    }

    public boolean shouldChunksExpire() {
        return (Boolean)this.shouldChunksExpire.get();
    }

    public int getExpireTimeInDays() {
        return (Integer)this.chunkExpire.get();
    }
}

