/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Network;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.CrashUtils;
import com.darkere.crashutils.Network.Network;
import com.darkere.crashutils.Network.OpenPlayerInvMessage;
import com.darkere.crashutils.Screens.PlayerInvContainer;
import com.mojang.authlib.GameProfile;
import java.util.LinkedHashMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public record PlayerInventoryRequestMessage(String playerName) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerInventoryRequestMessage> TYPE = new CustomPacketPayload.Type(CrashUtils.ResourceLocation("playerinventoryrequestmessage"));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, PlayerInventoryRequestMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PlayerInventoryRequestMessage::playerName, PlayerInventoryRequestMessage::new);

    public static boolean handle(PlayerInventoryRequestMessage data, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        MinecraftServer server = player.getServer();
        if (!player.hasPermissions(2)) {
            return true;
        }
        ServerPlayer otherPlayer = player.getServer().getPlayerList().getPlayerByName(data.playerName);
        if (otherPlayer == null) {
            Optional profile = server.getProfileCache().get(data.playerName);
            if (profile.isEmpty()) {
                CommandUtils.sendMessageToPlayer((Player)player, "Cannot find Player");
                return true;
            }
            otherPlayer = new FakePlayer(server.getLevel(Level.OVERWORLD), (GameProfile)profile.get());
            Optional nbt = server.playerDataStorage.load((Player)otherPlayer);
            if (nbt.isEmpty()) {
                CommandUtils.sendMessageToPlayer((Player)player, "Cannot load playerData");
                return true;
            }
            otherPlayer.load((CompoundTag)nbt.get());
        }
        LinkedHashMap<String, Integer> curios = new LinkedHashMap<String, Integer>();
        if (CrashUtils.curiosLoaded) {
            ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)otherPlayer).get()).getCurios().forEach((s, handler) -> curios.put((String)s, handler.getSlots()));
        }
        player.doCloseContainer();
        player.nextContainerCounter();
        int id = player.containerCounter;
        Network.sendToPlayer(player, new OpenPlayerInvMessage(curios, data.playerName, id));
        player.containerMenu = new PlayerInvContainer((Player)player, (Player)otherPlayer, id, null, null, 0);
        player.initMenu(player.containerMenu);
        return true;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

