/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.processor;

import com.iafenvoy.iceandfire.item.block.BlockDreadBase;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafProcessors;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DreadPortalProcessor
extends StructureProcessor {
    public static final DreadPortalProcessor INSTANCE = new DreadPortalProcessor();
    public static final MapCodec<DreadPortalProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    public static BlockState getRandomCrackedBlock(BlockState prev, RandomSource random) {
        float rand = random.nextFloat();
        if ((double)rand < 0.3) {
            return ((BlockDreadBase)IafBlocks.DREAD_STONE_BRICKS.get()).defaultBlockState();
        }
        if ((double)rand < 0.6) {
            return ((BlockDreadBase)IafBlocks.DREAD_STONE_BRICKS_CRACKED.get()).defaultBlockState();
        }
        return ((BlockDreadBase)IafBlocks.DREAD_STONE_BRICKS_MOSSY.get()).defaultBlockState();
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader world, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo currentBlockInfo, StructurePlaceSettings data) {
        RandomSource random = data.getRandom(pos);
        float integrity = 1.0f;
        if (random.nextFloat() <= integrity) {
            if (currentBlockInfo.state().is((Block)IafBlocks.DREAD_STONE_BRICKS.get())) {
                BlockState state = DreadPortalProcessor.getRandomCrackedBlock(null, random);
                return new StructureTemplate.StructureBlockInfo(pos, state, null);
            }
            return currentBlockInfo;
        }
        return currentBlockInfo;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)IafProcessors.DREAD_PORTAL_PROCESSOR.get();
    }
}

