/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.gen;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class WorldGenDreadRuin
extends Feature<NoneFeatureConfiguration> {
    private static final ResourceLocation STRUCTURE_0 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_0");
    private static final ResourceLocation STRUCTURE_1 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_1");
    private static final ResourceLocation STRUCTURE_2 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_2");
    private static final ResourceLocation STRUCTURE_3 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_3");
    private static final ResourceLocation STRUCTURE_4 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_4");
    private static final ResourceLocation STRUCTURE_5 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_5");
    private static final ResourceLocation STRUCTURE_6 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_6");
    private static final ResourceLocation STRUCTURE_7 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_7");
    private static final ResourceLocation STRUCTURE_8 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_8");
    private static final ResourceLocation STRUCTURE_9 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_9");
    private static final ResourceLocation STRUCTURE_10 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_10");
    private static final ResourceLocation STRUCTURE_11 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_11");
    private static final ResourceLocation STRUCTURE_12 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"dread_ruin_12");
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public WorldGenDreadRuin(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    public static Rotation getRotationFromFacing(Direction facing) {
        return switch (facing) {
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }

    private ResourceLocation getRandomStructure(RandomSource rand) {
        return switch (rand.nextInt(11)) {
            case 1 -> STRUCTURE_1;
            case 2 -> STRUCTURE_2;
            case 3 -> STRUCTURE_3;
            case 4 -> STRUCTURE_4;
            case 5 -> STRUCTURE_5;
            case 6 -> STRUCTURE_6;
            case 7 -> STRUCTURE_7;
            case 8 -> STRUCTURE_8;
            case 9 -> STRUCTURE_9;
            case 10 -> STRUCTURE_10;
            case 11 -> STRUCTURE_11;
            case 12 -> STRUCTURE_12;
            default -> STRUCTURE_0;
        };
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.level();
        RandomSource rand = context.random();
        BlockPos position = context.origin();
        ResourceLocation structure = this.getRandomStructure(rand);
        Direction facing = HORIZONTALS[rand.nextInt(3)];
        MinecraftServer server = worldIn.getLevel().getServer();
        Biome biome = (Biome)worldIn.getBiome(position).value();
        return false;
    }
}

