/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world;

import com.iafenvoy.iceandfire.registry.IafPlacementFilters;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class CustomBiomeFilter
extends PlacementFilter {
    private static final CustomBiomeFilter INSTANCE = new CustomBiomeFilter();
    public static final MapCodec<CustomBiomeFilter> CODEC = MapCodec.unit(() -> INSTANCE);

    private CustomBiomeFilter() {
    }

    public static CustomBiomeFilter biome() {
        return INSTANCE;
    }

    protected boolean shouldPlace(PlacementContext context, RandomSource random, BlockPos position) {
        PlacedFeature placedfeature = (PlacedFeature)context.topFeature().orElseThrow(() -> new IllegalStateException("Tried to biome check an unregistered feature, or a feature that should not restrict the biome"));
        boolean hasFeature = context.generator().getBiomeGenerationSettings(context.getLevel().getBiome(position)).hasFeature(placedfeature);
        if (!hasFeature) {
            hasFeature = context.generator().getBiomeGenerationSettings(context.getLevel().getBiome(context.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, position))).hasFeature(placedfeature);
        }
        return hasFeature;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)IafPlacementFilters.CUSTOM_BIOME_FILTER.get();
    }
}

