/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.layer;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LayerDragonBanner
extends RenderLayer<EntityDragonBase, TabulaModel<EntityDragonBase>> {
    private final RenderLayerParent<EntityDragonBase, TabulaModel<EntityDragonBase>> renderer;

    public LayerDragonBanner(RenderLayerParent<EntityDragonBase, TabulaModel<EntityDragonBase>> renderIn) {
        super(renderIn);
        this.renderer = renderIn;
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityDragonBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemstack = entity.getItemInHand(InteractionHand.OFF_HAND);
        matrixStackIn.pushPose();
        if (!itemstack.isEmpty() && itemstack.getItem() instanceof BannerItem) {
            float f = entity.getRenderSize() / 3.0f;
            float f2 = 1.0f / f;
            matrixStackIn.pushPose();
            this.postRender(StreamSupport.stream(((TabulaModel)this.renderer.getModel()).getAllParts().spliterator(), false).filter(cube -> cube.boxName.equals("BodyUpper")).findFirst().get(), matrixStackIn);
            matrixStackIn.translate(0.0f, -0.2f, 0.4f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStackIn.pushPose();
            matrixStackIn.scale(f2, f2, f2);
            Minecraft.getInstance().getItemRenderer().renderStatic(itemstack, ItemDisplayContext.NONE, packedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, (Level)Minecraft.getInstance().level, 0);
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
        matrixStackIn.popPose();
    }

    protected void postRender(AdvancedModelBox renderer, PoseStack matrixStackIn) {
        if (renderer.rotateAngleX == 0.0f && renderer.rotateAngleY == 0.0f && renderer.rotateAngleZ == 0.0f) {
            if (renderer.rotationPointX != 0.0f || renderer.rotationPointY != 0.0f || renderer.offsetZ != 0.0f) {
                matrixStackIn.translate(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotationPointZ * 0.0625f);
            }
        } else {
            matrixStackIn.translate(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotationPointZ * 0.0625f);
            if (renderer.rotateAngleZ != 0.0f) {
                matrixStackIn.mulPose(Axis.ZP.rotation(renderer.rotateAngleZ));
            }
            if (renderer.rotateAngleY != 0.0f) {
                matrixStackIn.mulPose(Axis.YP.rotation(renderer.rotateAngleY));
            }
            if (renderer.rotateAngleX != 0.0f) {
                matrixStackIn.mulPose(Axis.XP.rotation(renderer.rotateAngleX));
            }
        }
    }
}

