/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.EntityDreadThrall;
import com.iafenvoy.iceandfire.render.entity.layer.IHasArmorVariantResource;
import com.iafenvoy.iceandfire.render.entity.layer.LayerBipedArmorMultiple;
import com.iafenvoy.iceandfire.render.entity.layer.LayerGenericGlowing;
import com.iafenvoy.iceandfire.render.model.ModelDreadThrall;
import com.iafenvoy.uranus.client.model.util.HideableLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

public class RenderDreadThrall
extends MobRenderer<EntityDreadThrall, ModelDreadThrall>
implements IHasArmorVariantResource {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/dread_thrall.png");
    public static final ResourceLocation TEXTURE_EYES = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/dread_thrall_eyes.png");
    public static final ResourceLocation TEXTURE_LEG_ARMOR = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/thrall_legs.png");
    public static final ResourceLocation TEXTURE_ARMOR_0 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/thrall_chest_1.png");
    public static final ResourceLocation TEXTURE_ARMOR_1 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/thrall_chest_2.png");
    public static final ResourceLocation TEXTURE_ARMOR_2 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/thrall_chest_3.png");
    public static final ResourceLocation TEXTURE_ARMOR_3 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/thrall_chest_4.png");
    public static final ResourceLocation TEXTURE_ARMOR_4 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/thrall_chest_5.png");
    public static final ResourceLocation TEXTURE_ARMOR_5 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/thrall_chest_6.png");
    public static final ResourceLocation TEXTURE_ARMOR_6 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/thrall_chest_7.png");
    public static final ResourceLocation TEXTURE_ARMOR_7 = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/dread/thrall_chest_8.png");
    public final HideableLayer<EntityDreadThrall, ModelDreadThrall, ItemInHandLayer<EntityDreadThrall, ModelDreadThrall>> itemLayer;

    public RenderDreadThrall(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelDreadThrall(0.0f, false), 0.6f);
        this.addLayer(new LayerGenericGlowing(this, TEXTURE_EYES));
        this.itemLayer = new HideableLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()), (RenderLayerParent)this);
        this.addLayer((RenderLayer)this.itemLayer);
        this.addLayer(new LayerBipedArmorMultiple(this, new ModelDreadThrall(0.5f, true), new ModelDreadThrall(1.0f, true), TEXTURE_ARMOR_0, TEXTURE_LEG_ARMOR));
    }

    @Override
    public ResourceLocation getArmorResource(int variant, EquipmentSlot equipmentSlotType) {
        if (equipmentSlotType == EquipmentSlot.LEGS) {
            return TEXTURE_LEG_ARMOR;
        }
        return switch (variant) {
            case 1 -> TEXTURE_ARMOR_1;
            case 2 -> TEXTURE_ARMOR_2;
            case 3 -> TEXTURE_ARMOR_3;
            case 4 -> TEXTURE_ARMOR_4;
            case 5 -> TEXTURE_ARMOR_5;
            case 6 -> TEXTURE_ARMOR_6;
            case 7 -> TEXTURE_ARMOR_7;
            default -> TEXTURE_ARMOR_0;
        };
    }

    public void scale(EntityDreadThrall livingEntityIn, PoseStack stack, float partialTickTime) {
        stack.scale(0.95f, 0.95f, 0.95f);
        if (livingEntityIn.getAnimation() == ((ModelDreadThrall)this.getModel()).getSpawnAnimation()) {
            this.itemLayer.hidden = livingEntityIn.getAnimationTick() <= ((ModelDreadThrall)this.getModel()).getSpawnAnimation().getDuration() - 10;
            return;
        }
        this.itemLayer.hidden = false;
    }

    public ResourceLocation getTexture(EntityDreadThrall entity) {
        return TEXTURE;
    }
}

