/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.registry;

import com.iafenvoy.iceandfire.data.DragonArmor;
import com.iafenvoy.iceandfire.data.SeaSerpent;
import com.iafenvoy.iceandfire.data.TrollType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.impl.ParticleProviderHolder;
import com.iafenvoy.iceandfire.item.ItemDragonHorn;
import com.iafenvoy.iceandfire.item.ItemSummoningCrystal;
import com.iafenvoy.iceandfire.particle.ParticleBlood;
import com.iafenvoy.iceandfire.particle.ParticleDragonFlame;
import com.iafenvoy.iceandfire.particle.ParticleDragonFrost;
import com.iafenvoy.iceandfire.particle.ParticleDreadPortal;
import com.iafenvoy.iceandfire.particle.ParticleDreadTorch;
import com.iafenvoy.iceandfire.particle.ParticleGhostAppearance;
import com.iafenvoy.iceandfire.particle.ParticleHydraBreath;
import com.iafenvoy.iceandfire.particle.ParticlePixieDust;
import com.iafenvoy.iceandfire.particle.ParticleSerpentBubble;
import com.iafenvoy.iceandfire.particle.ParticleSirenAppearance;
import com.iafenvoy.iceandfire.particle.ParticleSirenMusic;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.render.armor.CopperArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.DeathWormArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.DragonSteelArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.ScaleArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.SeaSerpentArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.SilverArmorRenderer;
import com.iafenvoy.iceandfire.render.armor.TrollArmorRenderer;
import com.iafenvoy.iceandfire.render.block.RenderDreadPortal;
import com.iafenvoy.iceandfire.render.block.RenderDreadSpawner;
import com.iafenvoy.iceandfire.render.block.RenderEggInIce;
import com.iafenvoy.iceandfire.render.block.RenderGhostChest;
import com.iafenvoy.iceandfire.render.block.RenderJar;
import com.iafenvoy.iceandfire.render.block.RenderLectern;
import com.iafenvoy.iceandfire.render.block.RenderPixieHouse;
import com.iafenvoy.iceandfire.render.block.RenderPodium;
import com.iafenvoy.iceandfire.render.entity.RenderAmphithere;
import com.iafenvoy.iceandfire.render.entity.RenderAmphithereArrow;
import com.iafenvoy.iceandfire.render.entity.RenderChainTie;
import com.iafenvoy.iceandfire.render.entity.RenderCockatrice;
import com.iafenvoy.iceandfire.render.entity.RenderCyclops;
import com.iafenvoy.iceandfire.render.entity.RenderDeathWorm;
import com.iafenvoy.iceandfire.render.entity.RenderDragonArrow;
import com.iafenvoy.iceandfire.render.entity.RenderDragonBase;
import com.iafenvoy.iceandfire.render.entity.RenderDragonCharge;
import com.iafenvoy.iceandfire.render.entity.RenderDragonEgg;
import com.iafenvoy.iceandfire.render.entity.RenderDragonLightningCharge;
import com.iafenvoy.iceandfire.render.entity.RenderDragonSkull;
import com.iafenvoy.iceandfire.render.entity.RenderDreadBeast;
import com.iafenvoy.iceandfire.render.entity.RenderDreadGhoul;
import com.iafenvoy.iceandfire.render.entity.RenderDreadHorse;
import com.iafenvoy.iceandfire.render.entity.RenderDreadKnight;
import com.iafenvoy.iceandfire.render.entity.RenderDreadLich;
import com.iafenvoy.iceandfire.render.entity.RenderDreadLichSkull;
import com.iafenvoy.iceandfire.render.entity.RenderDreadScuttler;
import com.iafenvoy.iceandfire.render.entity.RenderDreadThrall;
import com.iafenvoy.iceandfire.render.entity.RenderGhost;
import com.iafenvoy.iceandfire.render.entity.RenderGhostSword;
import com.iafenvoy.iceandfire.render.entity.RenderGorgon;
import com.iafenvoy.iceandfire.render.entity.RenderHippocampus;
import com.iafenvoy.iceandfire.render.entity.RenderHippogryph;
import com.iafenvoy.iceandfire.render.entity.RenderHydra;
import com.iafenvoy.iceandfire.render.entity.RenderHydraArrow;
import com.iafenvoy.iceandfire.render.entity.RenderLightningDragon;
import com.iafenvoy.iceandfire.render.entity.RenderMobSkull;
import com.iafenvoy.iceandfire.render.entity.RenderNothing;
import com.iafenvoy.iceandfire.render.entity.RenderPixie;
import com.iafenvoy.iceandfire.render.entity.RenderSeaSerpent;
import com.iafenvoy.iceandfire.render.entity.RenderSeaSerpentArrow;
import com.iafenvoy.iceandfire.render.entity.RenderSiren;
import com.iafenvoy.iceandfire.render.entity.RenderStoneStatue;
import com.iafenvoy.iceandfire.render.entity.RenderStymphalianArrow;
import com.iafenvoy.iceandfire.render.entity.RenderStymphalianBird;
import com.iafenvoy.iceandfire.render.entity.RenderStymphalianFeather;
import com.iafenvoy.iceandfire.render.entity.RenderTideTrident;
import com.iafenvoy.iceandfire.render.entity.RenderTroll;
import com.iafenvoy.iceandfire.render.item.DeathwormGauntletRenderer;
import com.iafenvoy.iceandfire.render.item.GorgonHeadRenderer;
import com.iafenvoy.iceandfire.render.item.TEISRItemRenderer;
import com.iafenvoy.iceandfire.render.item.TideTridentRenderer;
import com.iafenvoy.iceandfire.render.item.TrollWeaponRenderer;
import com.iafenvoy.iceandfire.render.model.animator.FireDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.IceDragonTabulaModelAnimator;
import com.iafenvoy.iceandfire.render.model.animator.LightningTabulaDragonAnimator;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.iafenvoy.uranus.client.model.util.TabulaModelHandlerHelper;
import com.iafenvoy.uranus.client.render.DynamicItemRenderer;
import com.iafenvoy.uranus.client.render.armor.IArmorRendererBase;
import com.iafenvoy.uranus.util.function.MemorizeSupplier;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class IafRenderers {
    public static final ResourceLocation FIRE_DRAGON = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"firedragon/firedragon_ground");
    public static final ResourceLocation ICE_DRAGON = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"icedragon/icedragon_ground");
    public static final ResourceLocation LIGHTNING_DRAGON = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"lightningdragon/lightningdragon_ground");
    public static final ResourceLocation SEA_SERPENT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"seaserpent/seaserpent_base");

    public static void registerEntityRenderers() {
        EntityRendererRegistry.register(IafEntities.FIRE_DRAGON, x -> new RenderDragonBase(x, (TabulaModel<EntityDragonBase>)TabulaModelHandlerHelper.getModel((ResourceLocation)FIRE_DRAGON, (MemorizeSupplier)new MemorizeSupplier(FireDragonTabulaModelAnimator::new))));
        EntityRendererRegistry.register(IafEntities.ICE_DRAGON, manager -> new RenderDragonBase(manager, (TabulaModel<EntityDragonBase>)TabulaModelHandlerHelper.getModel((ResourceLocation)ICE_DRAGON, (MemorizeSupplier)new MemorizeSupplier(IceDragonTabulaModelAnimator::new))));
        EntityRendererRegistry.register(IafEntities.LIGHTNING_DRAGON, manager -> new RenderLightningDragon(manager, TabulaModelHandlerHelper.getModel((ResourceLocation)LIGHTNING_DRAGON, (MemorizeSupplier)new MemorizeSupplier(LightningTabulaDragonAnimator::new))));
        EntityRendererRegistry.register(IafEntities.DRAGON_EGG, RenderDragonEgg::new);
        EntityRendererRegistry.register(IafEntities.DRAGON_ARROW, RenderDragonArrow::new);
        EntityRendererRegistry.register(IafEntities.DRAGON_SKULL, RenderDragonSkull::new);
        EntityRendererRegistry.register(IafEntities.FIRE_DRAGON_CHARGE, manager -> new RenderDragonCharge(manager, true));
        EntityRendererRegistry.register(IafEntities.ICE_DRAGON_CHARGE, manager -> new RenderDragonCharge(manager, false));
        EntityRendererRegistry.register(IafEntities.LIGHTNING_DRAGON_CHARGE, RenderDragonLightningCharge::new);
        EntityRendererRegistry.register(IafEntities.HIPPOGRYPH_EGG, ThrownItemRenderer::new);
        EntityRendererRegistry.register(IafEntities.HIPPOGRYPH, RenderHippogryph::new);
        EntityRendererRegistry.register(IafEntities.STONE_STATUE, RenderStoneStatue::new);
        EntityRendererRegistry.register(IafEntities.GORGON, RenderGorgon::new);
        EntityRendererRegistry.register(IafEntities.PIXIE, RenderPixie::new);
        EntityRendererRegistry.register(IafEntities.CYCLOPS, RenderCyclops::new);
        EntityRendererRegistry.register(IafEntities.SIREN, RenderSiren::new);
        EntityRendererRegistry.register(IafEntities.HIPPOCAMPUS, RenderHippocampus::new);
        EntityRendererRegistry.register(IafEntities.DEATH_WORM, RenderDeathWorm::new);
        EntityRendererRegistry.register(IafEntities.DEATH_WORM_EGG, ThrownItemRenderer::new);
        EntityRendererRegistry.register(IafEntities.COCKATRICE, RenderCockatrice::new);
        EntityRendererRegistry.register(IafEntities.COCKATRICE_EGG, ThrownItemRenderer::new);
        EntityRendererRegistry.register(IafEntities.STYMPHALIAN_BIRD, RenderStymphalianBird::new);
        EntityRendererRegistry.register(IafEntities.STYMPHALIAN_FEATHER, RenderStymphalianFeather::new);
        EntityRendererRegistry.register(IafEntities.STYMPHALIAN_ARROW, RenderStymphalianArrow::new);
        EntityRendererRegistry.register(IafEntities.TROLL, RenderTroll::new);
        EntityRendererRegistry.register(IafEntities.AMPHITHERE, RenderAmphithere::new);
        EntityRendererRegistry.register(IafEntities.AMPHITHERE_ARROW, RenderAmphithereArrow::new);
        EntityRendererRegistry.register(IafEntities.SEA_SERPENT, RenderSeaSerpent::new);
        EntityRendererRegistry.register(IafEntities.SEA_SERPENT_BUBBLES, RenderNothing::new);
        EntityRendererRegistry.register(IafEntities.SEA_SERPENT_ARROW, RenderSeaSerpentArrow::new);
        EntityRendererRegistry.register(IafEntities.CHAIN_TIE, RenderChainTie::new);
        EntityRendererRegistry.register(IafEntities.PIXIE_CHARGE, RenderNothing::new);
        EntityRendererRegistry.register(IafEntities.TIDE_TRIDENT, RenderTideTrident::new);
        EntityRendererRegistry.register(IafEntities.MOB_SKULL, RenderMobSkull::new);
        EntityRendererRegistry.register(IafEntities.DREAD_SCUTTLER, RenderDreadScuttler::new);
        EntityRendererRegistry.register(IafEntities.DREAD_GHOUL, RenderDreadGhoul::new);
        EntityRendererRegistry.register(IafEntities.DREAD_BEAST, RenderDreadBeast::new);
        EntityRendererRegistry.register(IafEntities.DREAD_SCUTTLER, RenderDreadScuttler::new);
        EntityRendererRegistry.register(IafEntities.DREAD_THRALL, RenderDreadThrall::new);
        EntityRendererRegistry.register(IafEntities.DREAD_LICH, RenderDreadLich::new);
        EntityRendererRegistry.register(IafEntities.DREAD_LICH_SKULL, RenderDreadLichSkull::new);
        EntityRendererRegistry.register(IafEntities.DREAD_KNIGHT, RenderDreadKnight::new);
        EntityRendererRegistry.register(IafEntities.DREAD_HORSE, RenderDreadHorse::new);
        EntityRendererRegistry.register(IafEntities.HYDRA, RenderHydra::new);
        EntityRendererRegistry.register(IafEntities.HYDRA_BREATH, RenderNothing::new);
        EntityRendererRegistry.register(IafEntities.HYDRA_ARROW, RenderHydraArrow::new);
        EntityRendererRegistry.register(IafEntities.SLOW_MULTIPART, RenderNothing::new);
        EntityRendererRegistry.register(IafEntities.DRAGON_MULTIPART, RenderNothing::new);
        EntityRendererRegistry.register(IafEntities.CYCLOPS_MULTIPART, RenderNothing::new);
        EntityRendererRegistry.register(IafEntities.HYDRA_MULTIPART, RenderNothing::new);
        EntityRendererRegistry.register(IafEntities.GHOST, RenderGhost::new);
        EntityRendererRegistry.register(IafEntities.GHOST_SWORD, RenderGhostSword::new);
    }

    public static void registerParticleRenderers(Consumer<ParticleProviderHolder<?>> consumer) {
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.DRAGON_FLAME.get(), ParticleDragonFlame::provider));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.DRAGON_FLAME.get(), ParticleDragonFlame::provider));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.DRAGON_FROST.get(), ParticleDragonFrost::provider));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.BLOOD.get(), (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new ParticleBlood(world, x, y, z)));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.DREAD_PORTAL.get(), (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new ParticleDreadPortal(world, x, y, z, velocityX, velocityY, velocityZ)));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.DREAD_TORCH.get(), (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new ParticleDreadTorch(world, x, y, z, velocityX, velocityY, velocityZ)));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.GHOST_APPEARANCE.get(), (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new ParticleGhostAppearance(world, x, y, z, 1)));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.HYDRA_BREATH.get(), (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new ParticleHydraBreath(world, x, y, z, 1.0f, 1.0f, 1.0f)));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.PIXIE_DUST.get(), (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new ParticlePixieDust(world, x, y, z, 1.0f, 1.0f, 1.0f, 1.0f)));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.SERPENT_BUBBLE.get(), (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new ParticleSerpentBubble(world, x, y, z, velocityX, velocityY, velocityZ, 1.0f)));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.SIREN_APPEARANCE.get(), (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new ParticleSirenAppearance(world, x, y, z, 1)));
        consumer.accept(new ParticleProviderHolder((ParticleType)IafParticles.SIREN_MUSIC.get(), (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new ParticleSirenMusic(world, x, y, z, velocityX, velocityY, velocityZ)));
    }

    public static void registerBlockEntityRenderers() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)IafBlockEntities.PODIUM.get()), RenderPodium::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)IafBlockEntities.IAF_LECTERN.get()), RenderLectern::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)IafBlockEntities.EGG_IN_ICE.get()), RenderEggInIce::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)IafBlockEntities.PIXIE_HOUSE.get()), RenderPixieHouse::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)IafBlockEntities.PIXIE_JAR.get()), ctx -> new RenderJar());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)IafBlockEntities.DREAD_PORTAL.get()), RenderDreadPortal::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)IafBlockEntities.DREAD_SPAWNER.get()), RenderDreadSpawner::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)IafBlockEntities.GHOST_CHEST.get()), RenderGhostChest::new);
    }

    public static void registerArmorRenderers() {
        IArmorRendererBase.register((IArmorRendererBase)new CopperArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)IafItems.COPPER_HELMET.get(), (ItemLike)IafItems.COPPER_CHESTPLATE.get(), (ItemLike)IafItems.COPPER_LEGGINGS.get(), (ItemLike)IafItems.COPPER_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new DeathWormArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)IafItems.DEATHWORM_WHITE_HELMET.get(), (ItemLike)IafItems.DEATHWORM_WHITE_CHESTPLATE.get(), (ItemLike)IafItems.DEATHWORM_WHITE_LEGGINGS.get(), (ItemLike)IafItems.DEATHWORM_WHITE_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new DeathWormArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)IafItems.DEATHWORM_YELLOW_HELMET.get(), (ItemLike)IafItems.DEATHWORM_YELLOW_CHESTPLATE.get(), (ItemLike)IafItems.DEATHWORM_YELLOW_LEGGINGS.get(), (ItemLike)IafItems.DEATHWORM_YELLOW_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new DeathWormArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)IafItems.DEATHWORM_RED_HELMET.get(), (ItemLike)IafItems.DEATHWORM_RED_CHESTPLATE.get(), (ItemLike)IafItems.DEATHWORM_RED_LEGGINGS.get(), (ItemLike)IafItems.DEATHWORM_RED_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new DragonSteelArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)IafItems.DRAGONSTEEL_FIRE_HELMET.get(), (ItemLike)IafItems.DRAGONSTEEL_FIRE_CHESTPLATE.get(), (ItemLike)IafItems.DRAGONSTEEL_FIRE_LEGGINGS.get(), (ItemLike)IafItems.DRAGONSTEEL_FIRE_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new DragonSteelArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)IafItems.DRAGONSTEEL_ICE_HELMET.get(), (ItemLike)IafItems.DRAGONSTEEL_ICE_CHESTPLATE.get(), (ItemLike)IafItems.DRAGONSTEEL_ICE_LEGGINGS.get(), (ItemLike)IafItems.DRAGONSTEEL_ICE_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new DragonSteelArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)IafItems.DRAGONSTEEL_LIGHTNING_HELMET.get(), (ItemLike)IafItems.DRAGONSTEEL_LIGHTNING_CHESTPLATE.get(), (ItemLike)IafItems.DRAGONSTEEL_LIGHTNING_LEGGINGS.get(), (ItemLike)IafItems.DRAGONSTEEL_LIGHTNING_BOOTS.get()});
        IArmorRendererBase.register((IArmorRendererBase)new SilverArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)IafItems.SILVER_HELMET.get(), (ItemLike)IafItems.SILVER_CHESTPLATE.get(), (ItemLike)IafItems.SILVER_LEGGINGS.get(), (ItemLike)IafItems.SILVER_BOOTS.get()});
        for (DragonArmor armor : DragonArmor.values()) {
            IArmorRendererBase.register((IArmorRendererBase)new ScaleArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)armor.helmet.get(), (ItemLike)armor.chestplate.get(), (ItemLike)armor.leggings.get(), (ItemLike)armor.boots.get()});
        }
        for (SeaSerpent seaSerpent : SeaSerpent.values()) {
            IArmorRendererBase.register((IArmorRendererBase)new SeaSerpentArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)seaSerpent.helmet.get(), (ItemLike)seaSerpent.chestplate.get(), (ItemLike)seaSerpent.leggings.get(), (ItemLike)seaSerpent.boots.get()});
        }
        for (TrollType troll : TrollType.values()) {
            IArmorRendererBase.register((IArmorRendererBase)new TrollArmorRenderer(), (ItemLike[])new ItemLike[]{(ItemLike)troll.helmet.get(), (ItemLike)troll.chestplate.get(), (ItemLike)troll.leggings.get(), (ItemLike)troll.boots.get()});
        }
    }

    public static void registerItemRenderers() {
        DynamicItemRenderer.RENDERERS.put((Item)IafItems.DEATHWORM_GAUNTLET_RED.get(), new DeathwormGauntletRenderer());
        DynamicItemRenderer.RENDERERS.put((Item)IafItems.DEATHWORM_GAUNTLET_YELLOW.get(), new DeathwormGauntletRenderer());
        DynamicItemRenderer.RENDERERS.put((Item)IafItems.DEATHWORM_GAUNTLET_WHITE.get(), new DeathwormGauntletRenderer());
        DynamicItemRenderer.RENDERERS.put((Item)IafItems.GORGON_HEAD.get(), new GorgonHeadRenderer());
        DynamicItemRenderer.RENDERERS.put((Item)IafItems.TIDE_TRIDENT.get(), new TideTridentRenderer());
        DynamicItemRenderer.RENDERERS.put(((Block)IafBlocks.PIXIE_HOUSE_BIRCH.get()).asItem(), new TEISRItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((Block)IafBlocks.PIXIE_HOUSE_OAK.get()).asItem(), new TEISRItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((Block)IafBlocks.PIXIE_HOUSE_DARK_OAK.get()).asItem(), new TEISRItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((Block)IafBlocks.PIXIE_HOUSE_SPRUCE.get()).asItem(), new TEISRItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((Block)IafBlocks.PIXIE_HOUSE_MUSHROOM_RED.get()).asItem(), new TEISRItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((Block)IafBlocks.PIXIE_HOUSE_MUSHROOM_BROWN.get()).asItem(), new TEISRItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((Block)IafBlocks.DREAD_PORTAL.get()).asItem(), new TEISRItemRenderer());
        DynamicItemRenderer.RENDERERS.put(((Block)IafBlocks.GHOST_CHEST.get()).asItem(), new TEISRItemRenderer());
        for (TrollType.BuiltinWeapon weapon : TrollType.BuiltinWeapon.values()) {
            DynamicItemRenderer.RENDERERS.put(weapon.getItem(), new TrollWeaponRenderer());
        }
    }

    public static void registerRenderLayers() {
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.GOLD_PILE.get(), (Block)IafBlocks.SILVER_PILE.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.LECTERN.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.PODIUM_OAK.get(), (Block)IafBlocks.PODIUM_BIRCH.get(), (Block)IafBlocks.PODIUM_SPRUCE.get(), (Block)IafBlocks.PODIUM_JUNGLE.get(), (Block)IafBlocks.PODIUM_ACACIA.get(), (Block)IafBlocks.PODIUM_DARK_OAK.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.FIRE_LILY.get(), (Block)IafBlocks.FROST_LILY.get(), (Block)IafBlocks.LIGHTNING_LILY.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.DRAGON_ICE_SPIKES.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.DREAD_STONE_FACE.get()});
        RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)IafBlocks.EGG_IN_ICE.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.JAR_EMPTY.get(), (Block)IafBlocks.JAR_PIXIE_0.get(), (Block)IafBlocks.JAR_PIXIE_1.get(), (Block)IafBlocks.JAR_PIXIE_2.get(), (Block)IafBlocks.JAR_PIXIE_3.get(), (Block)IafBlocks.JAR_PIXIE_4.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.PIXIE_HOUSE_MUSHROOM_BROWN.get(), (Block)IafBlocks.PIXIE_HOUSE_MUSHROOM_RED.get(), (Block)IafBlocks.PIXIE_HOUSE_OAK.get(), (Block)IafBlocks.PIXIE_HOUSE_BIRCH.get(), (Block)IafBlocks.PIXIE_HOUSE_SPRUCE.get(), (Block)IafBlocks.PIXIE_HOUSE_DARK_OAK.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.DREAD_SPAWNER.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.DREAD_TORCH.get(), (Block)IafBlocks.BURNT_TORCH.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.DREAD_TORCH_WALL.get(), (Block)IafBlocks.BURNT_TORCH_WALL.get()});
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)IafBlocks.DREADWOOD_LEAVES.get(), (Block)IafBlocks.DREADWOOD_SAPLING.get()});
    }

    public static void registerModelPredicates() {
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)IafItems.DRAGON_BOW.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"pulling"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)IafItems.DRAGON_BOW.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"pull"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity == null ? 0.0f : (livingEntity.getUseItem() != itemStack ? 0.0f : (float)(itemStack.getUseDuration(livingEntity) - livingEntity.getUseItemRemainingTicks()) / 20.0f));
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)IafItems.DRAGON_HORN.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"iceorfire"), (stack, level, entity, p) -> (float)ItemDragonHorn.getDragonType(stack) * 0.25f);
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)IafItems.SUMMONING_CRYSTAL_FIRE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"has_dragon"), (stack, level, entity, p) -> ItemSummoningCrystal.hasDragon(stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)IafItems.SUMMONING_CRYSTAL_ICE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"has_dragon"), (stack, level, entity, p) -> ItemSummoningCrystal.hasDragon(stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)IafItems.SUMMONING_CRYSTAL_LIGHTNING.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"has_dragon"), (stack, level, entity, p) -> ItemSummoningCrystal.hasDragon(stack) ? 1.0f : 0.0f);
        ItemPropertiesRegistry.register((ItemLike)((ItemLike)IafItems.TIDE_TRIDENT.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"throwing"), (stack, level, entity, p) -> entity != null && entity.isUsingItem() && entity.getMainHandItem() == stack ? 1.0f : 0.0f);
    }
}

