/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.food;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class ItemGenericFood
extends Item {
    public ItemGenericFood(int amount, float saturation, boolean eatFast, boolean alwaysEdible) {
        super(new Item.Properties().food(ItemGenericFood.createFood(amount, saturation, eatFast, alwaysEdible, null)));
    }

    public ItemGenericFood(int amount, float saturation, boolean eatFast, boolean alwaysEdible, int stackSize) {
        super(new Item.Properties().food(ItemGenericFood.createFood(amount, saturation, eatFast, alwaysEdible, null)).stacksTo(stackSize));
    }

    public static FoodProperties createFood(int amount, float saturation, boolean eatFast, boolean alwaysEdible, MobEffectInstance potion) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.nutrition(amount);
        builder.saturationModifier(saturation);
        if (eatFast) {
            builder.fast();
        }
        if (alwaysEdible) {
            builder.alwaysEdible();
        }
        if (potion != null) {
            builder.effect(potion, 1.0f);
        }
        return builder.build();
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity LivingEntity2) {
        this.onFoodEaten(stack, worldIn, LivingEntity2);
        return super.finishUsingItem(stack, worldIn, LivingEntity2);
    }

    public abstract void onFoodEaten(ItemStack var1, Level var2, LivingEntity var3);
}

