/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.ability;

import com.iafenvoy.iceandfire.entity.EntityGhostSword;
import com.iafenvoy.iceandfire.item.ability.SwingHandAbility;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public interface SummonGhostSwordAbility
extends SwingHandAbility {
    @Override
    default public void active(LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player playerEntity = (Player)attacker;
            ItemStack stack = playerEntity.getItemInHand(InteractionHand.MAIN_HAND);
            if (playerEntity.getCooldowns().isOnCooldown(stack.getItem())) {
                return;
            }
            ItemAttributeModifiers dmg = (ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS);
            double totalDmg = 0.0;
            for (ItemAttributeModifiers.Entry modifier : dmg.modifiers()) {
                if (!modifier.attribute().equals((Object)Attributes.ATTACK_DAMAGE)) continue;
                totalDmg += modifier.modifier().amount();
            }
            playerEntity.playSound(SoundEvents.ZOMBIE_INFECT, 1.0f, 1.0f);
            EntityGhostSword shot = new EntityGhostSword((EntityType<? extends EntityGhostSword>)((EntityType)IafEntities.GHOST_SWORD.get()), playerEntity.level(), (LivingEntity)playerEntity, totalDmg * 0.5, stack);
            shot.shootFromRotation((Entity)playerEntity, playerEntity.getXRot(), playerEntity.getYRot(), 0.0f, 1.0f, 0.5f);
            playerEntity.level().addFreshEntity((Entity)shot);
            stack.hurtAndBreak(1, (LivingEntity)playerEntity, EquipmentSlot.MAINHAND);
            playerEntity.getCooldowns().addCooldown(stack.getItem(), 10);
        }
    }

    @Override
    default public void addDescription(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.ghost_sword.desc_0").withStyle(ChatFormatting.GRAY));
    }
}

