/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.data.BestiaryPages;
import com.iafenvoy.iceandfire.registry.IafDataComponents;
import com.iafenvoy.iceandfire.screen.handler.BestiaryScreenHandler;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.serialization.DynamicOps;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;

public class ItemBestiary
extends Item {
    public ItemBestiary() {
        super(new Item.Properties().stacksTo(1).component((DataComponentType)IafDataComponents.BESTIARY_PAGES.get(), List.of(BestiaryPages.INTRODUCTION.getName())));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, final Player playerIn, final InteractionHand handIn) {
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(FriendlyByteBuf buf) {
                    ItemStack stack = playerIn.getItemInHand(handIn);
                    CompoundTag compound = new CompoundTag();
                    compound.put("data", (Tag)ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)stack).resultOrPartial(arg_0 -> ((Logger)IceAndFire.LOGGER).error(arg_0)).orElse(new CompoundTag()));
                    buf.writeNbt((Tag)compound);
                }

                public Component getDisplayName() {
                    return Component.translatable((String)"bestiary_gui");
                }

                public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
                    return new BestiaryScreenHandler(syncId, playerInventory);
                }
            });
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.getItemInHand(handIn));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)344)) {
            tooltip.add((Component)Component.translatable((String)"bestiary.contains").withStyle(ChatFormatting.GRAY));
            List list = (List)stack.get((DataComponentType)IafDataComponents.BESTIARY_PAGES.get());
            if (list != null) {
                Set<BestiaryPages> pages = BestiaryPages.containedPages(list);
                for (BestiaryPages page : pages) {
                    tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.WHITE) + "-")).append((Component)Component.translatable((String)("bestiary." + page.getName().toLowerCase(Locale.ROOT)))).withStyle(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"bestiary.hold_shift").withStyle(ChatFormatting.GRAY));
        }
    }
}

