/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.entity.EntityPixie;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHousePayload;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.uranus.ServerHelper;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityPixieHouse
extends BlockEntity {
    private static final float PARTICLE_WIDTH = 0.3f;
    private static final float PARTICLE_HEIGHT = 0.6f;
    private final Random rand;
    public int houseType;
    public boolean hasPixie;
    public boolean tamedPixie;
    public UUID pixieOwnerUUID;
    public int pixieType;
    public NonNullList<ItemStack> pixieItems = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public BlockEntityPixieHouse(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.PIXIE_HOUSE.get(), pos, state);
        this.rand = new Random();
    }

    public static int getHouseTypeFromBlock(Block block) {
        if (block == IafBlocks.PIXIE_HOUSE_MUSHROOM_RED.get()) {
            return 1;
        }
        if (block == IafBlocks.PIXIE_HOUSE_MUSHROOM_BROWN.get()) {
            return 0;
        }
        if (block == IafBlocks.PIXIE_HOUSE_OAK.get()) {
            return 3;
        }
        if (block == IafBlocks.PIXIE_HOUSE_BIRCH.get()) {
            return 2;
        }
        if (block == IafBlocks.PIXIE_HOUSE_SPRUCE.get()) {
            return 5;
        }
        if (block == IafBlocks.PIXIE_HOUSE_DARK_OAK.get()) {
            return 4;
        }
        return 0;
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, BlockEntityPixieHouse entityPixieHouse) {
        if (entityPixieHouse.hasPixie) {
            level.addParticle((ParticleOptions)IafParticles.PIXIE_DUST.get(), (double)((float)pos.getX() + 0.5f) + (double)(entityPixieHouse.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)pos.getY() + (double)(entityPixieHouse.rand.nextFloat() * 0.6f), (double)((float)pos.getZ() + 0.5f) + (double)(entityPixieHouse.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)EntityPixie.PARTICLE_RGB[entityPixieHouse.pixieType][0], (double)EntityPixie.PARTICLE_RGB[entityPixieHouse.pixieType][1], (double)EntityPixie.PARTICLE_RGB[entityPixieHouse.pixieType][2]);
        }
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, BlockEntityPixieHouse entityPixieHouse) {
        if (entityPixieHouse.hasPixie && ThreadLocalRandom.current().nextInt(100) == 0) {
            entityPixieHouse.releasePixie();
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("HouseType", this.houseType);
        nbt.putBoolean("HasPixie", this.hasPixie);
        nbt.putInt("PixieType", this.pixieType);
        nbt.putBoolean("TamedPixie", this.tamedPixie);
        if (this.pixieOwnerUUID != null) {
            nbt.putUUID("PixieOwnerUUID", this.pixieOwnerUUID);
        }
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.pixieItems, (HolderLookup.Provider)registryLookup);
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithFullMetadata(registryLookup);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.houseType = nbt.getInt("HouseType");
        this.hasPixie = nbt.getBoolean("HasPixie");
        this.pixieType = nbt.getInt("PixieType");
        this.tamedPixie = nbt.getBoolean("TamedPixie");
        if (nbt.hasUUID("PixieOwnerUUID")) {
            this.pixieOwnerUUID = nbt.getUUID("PixieOwnerUUID");
        }
        this.pixieItems = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.pixieItems, (HolderLookup.Provider)registryLookup);
    }

    public void releasePixie() {
        EntityPixie pixie = new EntityPixie((EntityType<? extends EntityPixie>)((EntityType)IafEntities.PIXIE.get()), this.level);
        pixie.absMoveTo((float)this.worldPosition.getX() + 0.5f, (float)this.worldPosition.getY() + 1.0f, (float)this.worldPosition.getZ() + 0.5f, ThreadLocalRandom.current().nextInt(360), 0.0f);
        pixie.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)this.pixieItems.getFirst());
        pixie.setColor(this.pixieType);
        pixie.ticksUntilHouseAI = 500;
        pixie.setTame(this.tamedPixie, true);
        pixie.setOwnerUUID(this.pixieOwnerUUID);
        assert (this.level != null);
        if (!this.level.isClientSide) {
            this.level.addFreshEntity((Entity)pixie);
        }
        this.hasPixie = false;
        this.pixieType = 0;
        if (!this.level.isClientSide) {
            ServerHelper.sendToAll((CustomPacketPayload)new UpdatePixieHousePayload(this.worldPosition, false, 0));
        }
    }
}

