/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.entity.EntityDragonEgg;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityEggInIce
extends BlockEntity {
    public DragonColor type;
    public int age;
    public int ticksExisted;
    public UUID ownerUUID;
    private boolean spawned;

    public BlockEntityEggInIce(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.EGG_IN_ICE.get(), pos, state);
    }

    public static void tickEgg(Level level, BlockPos pos, BlockState state, BlockEntityEggInIce entityEggInIce) {
        ++entityEggInIce.age;
        if (entityEggInIce.age >= (Integer)IafCommonConfig.INSTANCE.dragon.eggBornTime.getValue() && entityEggInIce.type != null && !entityEggInIce.spawned && !level.isClientSide) {
            EntityIceDragon dragon = (EntityIceDragon)((EntityType)IafEntities.ICE_DRAGON.get()).create(level);
            assert (dragon != null);
            dragon.setPos((double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5);
            dragon.setVariant(entityEggInIce.type.name());
            dragon.setGender(ThreadLocalRandom.current().nextBoolean());
            dragon.setTame(true, false);
            dragon.setHunger(50);
            dragon.setOwnerUUID(entityEggInIce.ownerUUID);
            level.addFreshEntity((Entity)dragon);
            entityEggInIce.spawned = true;
            level.destroyBlock(pos, false);
            level.setBlockAndUpdate(pos, Blocks.WATER.defaultBlockState());
        }
        ++entityEggInIce.ticksExisted;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (this.type != null) {
            nbt.putString("Color", this.type.name());
        } else {
            nbt.putByte("Color", (byte)0);
        }
        nbt.putInt("Age", this.age);
        if (this.ownerUUID == null) {
            nbt.putString("OwnerUUID", "");
        } else {
            nbt.putUUID("OwnerUUID", this.ownerUUID);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.type = DragonColor.getById(nbt.getString("Color"));
        this.age = nbt.getInt("Age");
        UUID s = null;
        if (nbt.hasUUID("OwnerUUID")) {
            s = nbt.getUUID("OwnerUUID");
        } else {
            try {
                String s1 = nbt.getString("OwnerUUID");
                assert (this.level != null);
                s = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.level.getServer(), (String)s1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s != null) {
            this.ownerUUID = s;
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.saveAdditional(nbtTagCompound, registryLookup);
        return nbtTagCompound;
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.saveAdditional(nbtTagCompound, null);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void spawnEgg() {
        if (this.type != null) {
            EntityDragonEgg egg = new EntityDragonEgg((EntityType<EntityDragonEgg>)((EntityType)IafEntities.DRAGON_EGG.get()), this.level);
            egg.setEggType(this.type);
            egg.setPos((double)this.worldPosition.getX() + 0.5, this.worldPosition.getY() + 1, (double)this.worldPosition.getZ() + 0.5);
            egg.setOwnerId(this.ownerUUID);
            assert (this.level != null);
            if (!this.level.isClientSide) {
                this.level.addFreshEntity((Entity)egg);
            }
        }
    }
}

