/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntitySiren;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class SirenAIFindWaterTarget
extends Goal {
    private final EntitySiren mob;

    public SirenAIFindWaterTarget(EntitySiren mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        if (!this.mob.isInWater()) {
            return false;
        }
        if (this.mob.getRandom().nextFloat() < 0.5f) {
            Vec3 vec3;
            Path path = this.mob.getNavigation().getPath();
            if (path != null && path.getEndNode() != null) {
                this.mob.getNavigation().stop();
            }
            if (this.mob.getNavigation().isDone() && (vec3 = this.findWaterTarget()) != null) {
                this.mob.getNavigation().moveTo(vec3.x, vec3.y, vec3.z, 1.0);
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public Vec3 findWaterTarget() {
        if (this.mob.getTarget() == null || !this.mob.getTarget().isAlive()) {
            ArrayList<Vec3> water = new ArrayList<Vec3>();
            ArrayList<Vec3> singTargets = new ArrayList<Vec3>();
            int posX = (int)this.mob.getX();
            int posY = (int)this.mob.getY();
            int posZ = (int)this.mob.getZ();
            for (int x = posX - 5; x < posX + 5; ++x) {
                for (int y = posY - 5; y < posY + 5; ++y) {
                    for (int z = posZ - 5; z < posZ + 5; ++z) {
                        if (this.mob.wantsToSing() && this.mob.level().getBlockState(new BlockPos(x, y, z)).isSolid() && this.mob.level().isEmptyBlock(new BlockPos(x, y + 1, z)) && this.mob.isDirectPathBetweenPoints(this.mob.position(), new Vec3((double)x, (double)(y + 1), (double)z))) {
                            singTargets.add(new Vec3((double)x, (double)(y + 1), (double)z));
                        }
                        if (!this.mob.level().getBlockState(new BlockPos(x, y, z)).is(Blocks.WATER) || !this.mob.isDirectPathBetweenPoints(this.mob.position(), new Vec3((double)x, (double)y, (double)z))) continue;
                        water.add(new Vec3((double)x, (double)y, (double)z));
                    }
                }
            }
            if (!singTargets.isEmpty()) {
                return (Vec3)singTargets.get(this.mob.getRandom().nextInt(singTargets.size()));
            }
            if (!water.isEmpty()) {
                return (Vec3)water.get(this.mob.getRandom().nextInt(water.size()));
            }
        } else {
            BlockPos blockpos1 = this.mob.getTarget().blockPosition();
            return new Vec3((double)blockpos1.getX(), (double)blockpos1.getY(), (double)blockpos1.getZ());
        }
        return null;
    }
}

