/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntitySeaSerpent;
import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.ai.goal.Goal;

public class SeaSerpentAIGetInWater
extends Goal {
    private final EntitySeaSerpent creature;
    private BlockPos targetPos;

    public SeaSerpentAIGetInWater(EntitySeaSerpent creature) {
        this.creature = creature;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if ((this.creature.jumpCooldown == 0 || this.creature.onGround()) && !this.creature.level().getFluidState(this.creature.blockPosition()).is(FluidTags.WATER)) {
            this.targetPos = this.generateTarget();
            return this.targetPos != null;
        }
        return false;
    }

    public void start() {
        if (this.targetPos != null) {
            this.creature.getNavigation().moveTo((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ(), 1.5);
        }
    }

    public boolean canContinueToUse() {
        return !this.creature.getNavigation().isDone() && this.targetPos != null && !this.creature.level().getFluidState(this.creature.blockPosition()).is(FluidTags.WATER);
    }

    public BlockPos generateTarget() {
        BlockPos blockpos = null;
        int range = 16;
        for (int i = 0; i < 15; ++i) {
            BlockPos blockpos1 = this.creature.blockPosition().offset(ThreadLocalRandom.current().nextInt(16) - 8, 3, ThreadLocalRandom.current().nextInt(16) - 8);
            while (this.creature.level().isEmptyBlock(blockpos1) && blockpos1.getY() > 1) {
                blockpos1 = blockpos1.below();
            }
            if (!this.creature.level().getFluidState(blockpos1).is(FluidTags.WATER)) continue;
            blockpos = blockpos1;
        }
        return blockpos;
    }
}

