/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityPixie;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PixieAISteal
extends Goal {
    private final EntityPixie temptedEntity;
    private Player temptingPlayer;
    private int delayTemptCounter = 0;
    private boolean isRunning;

    public PixieAISteal(EntityPixie temptedEntityIn) {
        this.temptedEntity = temptedEntityIn;
    }

    public boolean canUse() {
        if (!((Boolean)IafCommonConfig.INSTANCE.pixie.stealItems.getValue()).booleanValue() || !this.temptedEntity.getMainHandItem().isEmpty() || this.temptedEntity.stealCooldown > 0) {
            return false;
        }
        if (this.temptedEntity.getRandom().nextInt(200) == 0) {
            return false;
        }
        if (this.temptedEntity.isTame()) {
            return false;
        }
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.level().getNearestPlayer((Entity)this.temptedEntity, 10.0);
        return this.temptingPlayer != null && this.temptedEntity.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && !this.temptingPlayer.getInventory().isEmpty() && !this.temptingPlayer.isCreative();
    }

    public boolean canContinueToUse() {
        return !this.temptedEntity.isTame() && this.temptedEntity.getMainHandItem().isEmpty() && this.delayTemptCounter == 0 && this.temptedEntity.stealCooldown == 0;
    }

    public void start() {
        this.isRunning = true;
    }

    public void stop() {
        this.temptingPlayer = null;
        if (this.delayTemptCounter < 10) {
            this.delayTemptCounter += 10;
        }
        this.isRunning = false;
    }

    public void tick() {
        this.temptedEntity.getLookControl().setLookAt((Entity)this.temptingPlayer, (float)(this.temptedEntity.getMaxHeadYRot() + 20), (float)this.temptedEntity.getMaxHeadXRot());
        ArrayList<Integer> slotlist = new ArrayList<Integer>();
        if (this.temptedEntity.distanceToSqr((Entity)this.temptingPlayer) < 3.0 && !this.temptingPlayer.getInventory().isEmpty()) {
            for (int i = 0; i < this.temptingPlayer.getInventory().getContainerSize(); ++i) {
                ItemStack targetStack = this.temptingPlayer.getInventory().getItem(i);
                if (Inventory.isHotbarSlot((int)i) || targetStack.isEmpty() || !targetStack.isStackable() || targetStack.is(IafItemTags.PIXIE_STOLEN_BLACKLIST)) continue;
                slotlist.add(i);
            }
            if (!slotlist.isEmpty()) {
                int slot = slotlist.size() == 1 ? (Integer)slotlist.getFirst() : (Integer)slotlist.get(ThreadLocalRandom.current().nextInt(slotlist.size()));
                ItemStack randomItem = this.temptingPlayer.getInventory().getItem(slot);
                this.temptedEntity.setItemInHand(InteractionHand.MAIN_HAND, randomItem);
                this.temptingPlayer.getInventory().removeItemNoUpdate(slot);
                this.temptedEntity.playSound((SoundEvent)IafSounds.PIXIE_TAUNT.get(), 1.0f, 1.0f);
                for (EntityPixie pixie : this.temptingPlayer.level().getEntitiesOfClass(EntityPixie.class, this.temptedEntity.getBoundingBox().inflate(40.0))) {
                    pixie.stealCooldown = 1000 + pixie.getRandom().nextInt(3000);
                }
                if (this.temptingPlayer != null) {
                    this.temptingPlayer.addEffect(new MobEffectInstance(this.temptedEntity.negativePotions[this.temptedEntity.getColor()], 100));
                }
            } else {
                this.delayTemptCounter = 200;
            }
        } else {
            this.temptedEntity.getMoveControl().setWantedPosition(this.temptingPlayer.getX(), this.temptingPlayer.getY() + 1.5, this.temptingPlayer.getZ(), 1.0);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

