/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AdvancedPathNavigate;
import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class DragonAIAttackMelee
extends Goal {
    protected final EntityDragonBase dragon;
    private final boolean longMemory;
    private final double speedTowardsTarget;
    private int attackTick;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;

    public DragonAIAttackMelee(EntityDragonBase dragon, double speedIn, boolean useLongMemory) {
        this.dragon = dragon;
        this.longMemory = useLongMemory;
        this.speedTowardsTarget = speedIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.dragon.getTarget();
        if (!(this.dragon.getNavigation() instanceof AdvancedPathNavigate)) {
            return false;
        }
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.isAlive()) {
            return false;
        }
        if (!this.dragon.canMove() || this.dragon.isHovering() || this.dragon.isFlying()) {
            return false;
        }
        ((AdvancedPathNavigate)this.dragon.getNavigation()).moveToLivingEntity((Entity)livingEntity, this.speedTowardsTarget);
        return true;
    }

    public boolean canContinueToUse() {
        if (!(this.dragon.getNavigation() instanceof AdvancedPathNavigate)) {
            return false;
        }
        LivingEntity livingEntity = this.dragon.getTarget();
        if (livingEntity != null && !livingEntity.isAlive()) {
            this.stop();
            return false;
        }
        return livingEntity != null && livingEntity.isAlive() && !this.dragon.isFlying() && !this.dragon.isHovering();
    }

    public void start() {
        this.delayCounter = 0;
    }

    public void stop() {
        LivingEntity LivingEntity2 = this.dragon.getTarget();
        if (LivingEntity2 instanceof Player && (LivingEntity2.isSpectator() || ((Player)LivingEntity2).isCreative())) {
            this.dragon.setTarget(null);
        }
        this.dragon.getNavigation().stop();
    }

    public void tick() {
        LivingEntity entity = this.dragon.getTarget();
        if (this.delayCounter > 0) {
            --this.delayCounter;
        }
        if (entity != null) {
            if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_SHAKEPREY) {
                this.stop();
                return;
            }
            ((AdvancedPathNavigate)this.dragon.getNavigation()).moveToLivingEntity((Entity)entity, this.speedTowardsTarget);
            double d0 = this.dragon.distanceToSqr(entity.getX(), entity.getBoundingBox().minY, entity.getZ());
            double d1 = this.getAttackReachSqr(entity);
            --this.delayCounter;
            if ((this.longMemory || this.dragon.getSensing().hasLineOfSight((Entity)entity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entity.distanceToSqr(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.dragon.getRandom().nextFloat() < 0.05f)) {
                this.targetX = entity.getX();
                this.targetY = entity.getBoundingBox().minY;
                this.targetZ = entity.getZ();
                this.delayCounter = 4 + this.dragon.getRandom().nextInt(7);
                if (d0 > 1024.0) {
                    this.delayCounter += 10;
                } else if (d0 > 256.0) {
                    this.delayCounter += 5;
                }
                if (this.dragon.canMove()) {
                    this.delayCounter += 15;
                }
            }
            this.attackTick = Math.max(this.attackTick - 1, 0);
            if (d0 <= d1 && this.attackTick == 0) {
                this.attackTick = 20;
                this.dragon.swing(InteractionHand.MAIN_HAND);
                this.dragon.doHurtTarget((Entity)entity);
            }
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.dragon.getBbWidth() * 2.0f * this.dragon.getBbWidth() * 2.0f + attackTarget.getBbWidth();
    }
}

