/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CockatriceAIStareAttack
extends Goal {
    private final EntityCockatrice entity;
    private final double moveSpeedAmp;
    private int seeTime;
    private BlockPos target = null;

    public CockatriceAIStareAttack(EntityCockatrice cockatrice, double speedAmplifier, int delay, float maxDistance) {
        this.entity = cockatrice;
        this.moveSpeedAmp = speedAmplifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public static boolean isEntityLookingAt(LivingEntity looker, LivingEntity seen, double degree) {
        Vec3 Vector3d = looker.getViewVector(1.0f).normalize();
        Vec3 Vector3d1 = new Vec3(seen.getX() - looker.getX(), seen.getBoundingBox().minY + (double)seen.getEyeHeight() - (looker.getY() + (double)looker.getEyeHeight()), seen.getZ() - looker.getZ());
        Vector3d1 = Vector3d1.normalize();
        double d0 = Vector3d1.length();
        double d1 = Vector3d.dot(Vector3d1);
        return d1 > 1.0 - degree / d0 && !looker.isSpectator();
    }

    public boolean canUse() {
        return this.entity.getTarget() != null;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void stop() {
        super.stop();
        this.seeTime = 0;
        this.entity.stopUsingItem();
        this.entity.getNavigation().stop();
        this.target = null;
    }

    public void tick() {
        LivingEntity LivingEntity2 = this.entity.getTarget();
        if (LivingEntity2 != null) {
            boolean flag1;
            if (EntityGorgon.isStoneMob(LivingEntity2) || !LivingEntity2.isAlive()) {
                this.entity.setTarget(null);
                this.entity.setTargetedEntity(0);
                this.stop();
                return;
            }
            if (!CockatriceAIStareAttack.isEntityLookingAt(LivingEntity2, (LivingEntity)this.entity, 0.6f) || LivingEntity2.xo != this.entity.getX() || LivingEntity2.yo != this.entity.getY() || LivingEntity2.zo != this.entity.getZ()) {
                this.entity.getNavigation().stop();
                BlockPos pos = DragonUtils.getBlockInTargetsViewCockatrice(this.entity, LivingEntity2);
                if (this.target == null || pos.distSqr((Vec3i)this.target) > 4.0) {
                    this.target = pos;
                }
            }
            this.entity.setTargetedEntity(LivingEntity2.getId());
            this.entity.distanceToSqr(LivingEntity2.getX(), LivingEntity2.getBoundingBox().minY, LivingEntity2.getZ());
            boolean flag = this.entity.getSensing().hasLineOfSight((Entity)LivingEntity2);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (this.target != null && this.entity.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ()) > 16.0 && !CockatriceAIStareAttack.isEntityLookingAt(LivingEntity2, (LivingEntity)this.entity, 0.6f)) {
                this.entity.getNavigation().moveTo((double)this.target.getX(), (double)this.target.getY(), (double)this.target.getZ(), this.moveSpeedAmp);
            }
            this.entity.getLookControl().setLookAt(LivingEntity2.getX(), LivingEntity2.getY() + (double)LivingEntity2.getEyeHeight(), LivingEntity2.getZ(), (float)this.entity.getMaxHeadYRot(), (float)this.entity.getMaxHeadXRot());
        }
    }
}

