/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityAmphithere;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class AmphithereAIAttackMelee
extends Goal {
    protected final EntityAmphithere attacker;
    final double speedTowardsTarget;
    final boolean longMemory;
    private final boolean canPenalize = false;
    protected int attackTick;
    Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int failedPathFindingPenalty = 0;

    public AmphithereAIAttackMelee(EntityAmphithere amphithere, double speedIn, boolean useLongMemory) {
        this.attacker = amphithere;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity LivingEntity2 = this.attacker.getTarget();
        if (!this.attacker.canMove()) {
            return false;
        }
        if (LivingEntity2 == null) {
            return false;
        }
        if (!LivingEntity2.isAlive()) {
            return false;
        }
        Objects.requireNonNull(this);
        this.path = this.attacker.getNavigation().createPath((Entity)LivingEntity2, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(LivingEntity2) >= this.attacker.distanceToSqr(LivingEntity2.getX(), LivingEntity2.getBoundingBox().minY, LivingEntity2.getZ());
    }

    public boolean canContinueToUse() {
        LivingEntity living = this.attacker.getTarget();
        if (living == null) {
            return false;
        }
        if (!living.isAlive()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.getNavigation().isDone();
        }
        if (!this.attacker.isWithinRestriction(living.blockPosition())) {
            return false;
        }
        return !(living instanceof Player) || !living.isSpectator() && !((Player)living).isCreative();
    }

    public void start() {
        if (this.attacker.isFlying()) {
            this.attacker.getMoveControl().setWantedPosition(this.targetX, this.targetY, this.targetZ, (double)0.1f);
        } else {
            this.attacker.getNavigation().moveTo(this.path, this.speedTowardsTarget);
        }
        this.delayCounter = 0;
    }

    public void stop() {
        LivingEntity LivingEntity2 = this.attacker.getTarget();
        if (LivingEntity2 instanceof Player && (LivingEntity2.isSpectator() || ((Player)LivingEntity2).isCreative())) {
            this.attacker.setTarget(null);
        }
        this.attacker.getNavigation().stop();
    }

    public void tick() {
        LivingEntity LivingEntity2 = this.attacker.getTarget();
        if (this.attacker.isFlying()) {
            assert (LivingEntity2 != null);
            this.attacker.getMoveControl().setWantedPosition(LivingEntity2.getX(), LivingEntity2.getY() + (double)LivingEntity2.getEyeHeight(), LivingEntity2.getZ(), 0.1);
        }
        this.attacker.getLookControl().setLookAt((Entity)LivingEntity2, 30.0f, 30.0f);
        assert (LivingEntity2 != null);
        double d0 = this.attacker.distanceToSqr(LivingEntity2.getX(), LivingEntity2.getBoundingBox().minY, LivingEntity2.getZ());
        --this.delayCounter;
        if ((this.longMemory || this.attacker.getSensing().hasLineOfSight((Entity)LivingEntity2)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || LivingEntity2.distanceToSqr(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.getRandom().nextFloat() < 0.05f)) {
            this.targetX = LivingEntity2.getX();
            this.targetY = LivingEntity2.getBoundingBox().minY;
            this.targetZ = LivingEntity2.getZ();
            this.delayCounter = 4 + this.attacker.getRandom().nextInt(7);
            Objects.requireNonNull(this);
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.getNavigation().moveTo((Entity)LivingEntity2, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.checkAndPerformAttack(LivingEntity2, d0);
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        double d0 = this.getAttackReachSqr(enemy);
        if (distToEnemySqr <= d0) {
            this.attackTick = 20;
            this.attacker.swing(InteractionHand.MAIN_HAND);
            this.attacker.doHurtTarget((Entity)enemy);
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.getBbWidth() * 2.0f * this.attacker.getBbWidth() * 2.0f + attackTarget.getBbWidth();
    }
}

