/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityDragonFireCharge;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonDestructionManager;
import com.iafenvoy.iceandfire.particle.DragonFlameParticleType;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafEntityTags;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityFireDragon
extends EntityDragonBase {
    public static final ResourceLocation FEMALE_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/dragon/fire_dragon_female");
    public static final ResourceLocation MALE_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/dragon/fire_dragon_male");
    public static final ResourceLocation SKELETON_LOOT = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"entities/dragon/fire_dragon_skeleton");

    public EntityFireDragon(EntityType<? extends EntityFireDragon> t, Level worldIn) {
        super(t, worldIn, DragonType.FIRE, 1.0, 1 + (Integer)IafCommonConfig.INSTANCE.dragon.attackDamage.getValue(), (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue() * 0.04, (Double)IafCommonConfig.INSTANCE.dragon.maxHealth.getValue(), 0.15f, 0.4f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)30);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    protected boolean shouldTarget(Entity entity) {
        if (entity instanceof EntityDragonBase && !this.isTame()) {
            return entity.getType() != this.getType() && this.getBbWidth() >= entity.getBbWidth() && !((EntityDragonBase)entity).isMobDead();
        }
        return entity instanceof Player || DragonUtils.isDragonTargetable(entity, IafEntityTags.FIRE_DRAGON_TARGETS) || !this.isTame() && DragonUtils.isVillager(entity);
    }

    @Override
    public String getVariantName(int variant) {
        return switch (variant) {
            case 1 -> "green_";
            case 2 -> "bronze_";
            case 3 -> "gray_";
            default -> "red_";
        };
    }

    @Override
    public boolean doHurtTarget(Entity entityIn) {
        this.getLookControl().setLookAt(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0), entityIn.position().add(0.0, (double)(entityIn.getBbHeight() / 2.0f), 0.0)) && entityIn.getBbWidth() < this.getBbWidth() * 0.5f && this.getControllingPassenger() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.startRiding((Entity)this);
                    }
                    if (flag) break;
                    this.groundAttack = IafDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        LivingEntity attackTarget = this.getTarget();
        if (!this.level().isClientSide && attackTarget != null) {
            if (this.getBoundingBox().inflate((double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f)).intersects(attackTarget.getBoundingBox())) {
                this.doHurtTarget((Entity)attackTarget);
            }
            if (this.groundAttack == IafDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.onGround())) {
                this.shootFireAtMob(attackTarget);
            }
            if (this.airAttack == IafDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.distanceToSqr((Entity)attackTarget) < 100.0) {
                double difX = attackTarget.getX() - this.getX();
                double difY = attackTarget.getY() + (double)attackTarget.getBbHeight() - this.getY();
                double difZ = attackTarget.getZ() - this.getZ();
                this.setDeltaMovement(this.getDeltaMovement().add(difX * 0.1, difY * 0.1, difZ * 0.1));
                if (this.getBoundingBox().inflate((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).intersects(attackTarget.getBoundingBox())) {
                    this.doHurtTarget((Entity)attackTarget);
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
    }

    @Override
    protected void breathFireAtPos(BlockPos burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.setYRot(this.yBodyRot);
                if (this.tickCount % 5 == 0) {
                    this.playSound((SoundEvent)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                }
                this.stimulateFire((float)burningTarget.getX() + 0.5f, (float)burningTarget.getY() + 0.5f, (float)burningTarget.getZ() + 0.5f, 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.getRandom().nextInt(5) == 0 && !this.isBaby()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.setYRot(this.yBodyRot);
                Vec3 headVec = this.getHeadPosition();
                this.playSound((SoundEvent)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                double d2 = controller.getLookAngle().x;
                double d3 = controller.getLookAngle().y;
                double d4 = controller.getLookAngle().z;
                float inaccuracy = 1.0f;
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.FIRE_DRAGON_CHARGE.get()), this.level(), this, d2 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.setPos(headVec.x, headVec.y, headVec.z);
                if (!this.level().isClientSide) {
                    this.level().addFreshEntity((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                HitResult mop;
                this.setYRot(this.yBodyRot);
                if (this.tickCount % 5 == 0) {
                    this.playSound((SoundEvent)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.getLocation().x, mop.getLocation().y, mop.getLocation().z, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    protected float getBlockSpeedFactor() {
        if (this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).is(BlockTags.SOUL_SPEED_BLOCKS)) {
            return this.getDragonStage() >= 2 ? 1.0f : 0.8f;
        }
        return super.getBlockSpeedFactor();
    }

    @Override
    public void travel(Vec3 pTravelVector) {
        if (this.isInLava()) {
            if (this.isEffectiveAi() && this.getControllingPassenger() == null) {
                this.moveRelative(this.getSpeed(), pTravelVector);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
                this.getTarget();
            } else {
                Objects.requireNonNull(this);
                if (this.getControllingPassenger() != null && !this.isHovering() && !this.isFlying()) {
                    LivingEntity rider = this.getControllingPassenger();
                    float speed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
                    float lavaSpeedMod = (float)((double)0.28f + 0.1 * Mth.map((double)speed, (double)this.minimumSpeed, (double)this.maximumSpeed, (double)0.0, (double)1.5));
                    speed *= lavaSpeedMod;
                    speed *= rider.isSprinting() ? 1.4f : 1.0f;
                    float vertical = 0.0f;
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = 0.8f;
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = -0.8f;
                    } else if (this.isGoingUp() && this.isGoingDown() && this.isControlledByLocalInstance()) {
                        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, (double)0.3f, 1.0));
                    }
                    Vec3 travelVector = new Vec3((double)rider.xxa, (double)vertical, (double)rider.zza);
                    if (this.isControlledByLocalInstance()) {
                        this.setSpeed(speed);
                        this.moveRelative(this.getSpeed(), travelVector);
                        this.move(MoverType.SELF, this.getDeltaMovement());
                        Vec3 currentMotion = this.getDeltaMovement();
                        if (this.horizontalCollision) {
                            currentMotion = new Vec3(currentMotion.x, 0.2, currentMotion.z);
                        }
                        this.setDeltaMovement(currentMotion.scale(0.7));
                        this.calculateEntityAnimation(false);
                    } else {
                        this.setDeltaMovement(Vec3.ZERO);
                    }
                    this.tryCheckInsideBlocks();
                } else {
                    super.travel(pTravelVector);
                }
            }
        } else {
            Objects.requireNonNull(this);
            if (this.getControllingPassenger() != null && !this.isHovering() && !this.isFlying() && this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getFluidState().is(FluidTags.LAVA)) {
                LivingEntity rider = this.getControllingPassenger();
                double forward = rider.zza;
                double strafing = rider.xxa;
                double vertical = pTravelVector.y;
                float speed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
                float groundSpeedModifier = (float)((double)1.8f * this.getFlightSpeedModifier());
                speed *= groundSpeedModifier;
                forward *= rider.isSprinting() ? (double)1.2f : 1.0;
                forward *= rider.zza > 0.0f ? 1.0 : (double)0.2f;
                strafing *= (double)0.05f;
                if (this.isControlledByLocalInstance()) {
                    this.setSpeed(speed);
                    super.travel(new Vec3(strafing, vertical, forward));
                    Vec3 currentMotion = this.getDeltaMovement();
                    if (this.horizontalCollision) {
                        currentMotion = new Vec3(currentMotion.x, 0.2, currentMotion.z);
                    }
                    this.setDeltaMovement(currentMotion.scale(0.7));
                } else {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                this.tryCheckInsideBlocks();
            } else {
                super.travel(pTravelVector);
            }
        }
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    private void shootFireAtMob(LivingEntity entity) {
        if (this.usingGroundAttack && this.groundAttack == IafDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IafDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IafDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.getRandom().nextInt(5) == 0 || !this.usingGroundAttack && this.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 20) {
                    this.setYRot(this.yBodyRot);
                    Vec3 headVec = this.getHeadPosition();
                    double d2 = entity.getX() - headVec.x;
                    double d3 = entity.getY() - headVec.y;
                    double d4 = entity.getZ() - headVec.z;
                    float inaccuracy = 1.0f;
                    this.playSound((SoundEvent)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                    EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.FIRE_DRAGON_CHARGE.get()), this.level(), this, d2 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    entitylargefireball.setPos(headVec.x, headVec.y, headVec.z);
                    if (!this.level().isClientSide) {
                        this.level().addFreshEntity((Entity)entitylargefireball);
                    }
                    if (!entity.isAlive()) {
                        this.setBreathingFire(false);
                    }
                    this.randomizeAttacks();
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.setYRot(this.yBodyRot);
                    if (this.tickCount % 5 == 0) {
                        this.playSound((SoundEvent)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.getX(), entity.getY(), entity.getZ(), 1);
                    if (!entity.isAlive()) {
                        this.setBreathingFire(false);
                        this.randomizeAttacks();
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.lookAt((Entity)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (((IafEvents.DragonFire)IafEvents.ON_DRAGON_FIRE_BLOCK.invoker()).onFireBlock(this, burnX, burnY, burnZ)) {
            return;
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.setYRot(this.yBodyRot);
                Vec3 headVec = this.getHeadPosition();
                double d2 = burnX - headVec.x;
                double d3 = burnY - headVec.y;
                double d4 = burnZ - headVec.z;
                float inaccuracy = 1.0f;
                this.playSound((SoundEvent)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                EntityDragonFireCharge entitylargefireball = new EntityDragonFireCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.FIRE_DRAGON_CHARGE.get()), this.level(), this, d2 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.random.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                entitylargefireball.setPos(headVec.x, headVec.y, headVec.z);
                if (!this.level().isClientSide) {
                    this.level().addFreshEntity((Entity)entitylargefireball);
                }
                this.randomizeAttacks();
            }
            return;
        }
        this.getNavigation().stop();
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        Vec3 headPos = this.getHeadPosition();
        double d2 = burnX - headPos.x;
        double d3 = burnY - headPos.y;
        double d4 = burnZ - headPos.z;
        double distance = Math.max(2.5 * Math.sqrt(this.distanceToSqr(burnX, burnY, burnZ)), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int particleCount = this.getDragonStage() <= 3 ? 6 : 3;
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.x + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.y + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.z + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                if (this.random.nextInt(particleCount) == 0) {
                    Vec3 velocity = new Vec3(progressX, progressY, progressZ).subtract(headPos);
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        serverWorld.sendParticles((ParticleOptions)new DragonFlameParticleType(this.getAgeScale()), headPos.x, headPos.y, headPos.z, 0, velocity.x, velocity.y, velocity.z, 1.0);
                    }
                }
            } else if (!this.level().isClientSide) {
                BlockHitResult result = this.level().clip(new ClipContext(new Vec3(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ()), new Vec3(progressX, progressY, progressZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                Vec3 vec3 = result.getLocation();
                BlockPos pos = BlockPos.containing((Position)vec3);
                IafDragonDestructionManager.destroyAreaBreath(this.level(), pos, this);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.random.nextFloat() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.random.nextFloat() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.random.nextFloat() * 3.0 - 1.5;
            if (!this.level().isClientSide) {
                IafDragonDestructionManager.destroyAreaBreath(this.level(), BlockPos.containing((double)spawnX, (double)spawnY, (double)spawnZ), this);
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return this.isTeen() ? (SoundEvent)IafSounds.FIREDRAGON_TEEN_IDLE.get() : (this.isMature() ? (SoundEvent)IafSounds.FIREDRAGON_ADULT_IDLE.get() : (SoundEvent)IafSounds.FIREDRAGON_CHILD_IDLE.get());
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.isTeen() ? (SoundEvent)IafSounds.FIREDRAGON_TEEN_HURT.get() : (this.isMature() ? (SoundEvent)IafSounds.FIREDRAGON_ADULT_HURT.get() : (SoundEvent)IafSounds.FIREDRAGON_CHILD_HURT.get());
    }

    protected SoundEvent getDeathSound() {
        return this.isTeen() ? (SoundEvent)IafSounds.FIREDRAGON_TEEN_DEATH.get() : (this.isMature() ? (SoundEvent)IafSounds.FIREDRAGON_ADULT_DEATH.get() : (SoundEvent)IafSounds.FIREDRAGON_CHILD_DEATH.get());
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? (SoundEvent)IafSounds.FIREDRAGON_TEEN_ROAR.get() : (this.isMature() ? (SoundEvent)IafSounds.FIREDRAGON_ADULT_ROAR.get() : (SoundEvent)IafSounds.FIREDRAGON_CHILD_ROAR.get());
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT, ANIMATION_SPEAK, ANIMATION_BITE, ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR, ANIMATION_EPIC_ROAR};
    }

    public boolean isFood(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() != null && stack.getItem() == IafItems.FIRE_STEW.get();
    }

    @Override
    protected void spawnDeathParticles() {
        for (int k = 0; k < 3; ++k) {
            double d2 = this.random.nextGaussian() * 0.02;
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            if (!this.level().isClientSide) continue;
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getY() + (double)(this.random.nextFloat() * this.getBbHeight()), this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), d2, d0, d1);
        }
    }

    @Override
    public void spawnBabyParticles() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 5; ++i) {
                float radiusAdd = (float)i * 0.15f;
                float headPosX = (float)(this.getX() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.cos((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
                float headPosZ = (float)(this.getY() + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd) * Mth.sin((float)((float)((double)(this.getYRot() + 90.0f) * Math.PI / 180.0)))));
                float headPosY = (float)(this.getZ() + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                this.level().addParticle((ParticleOptions)new DragonFlameParticleType(this.getAgeScale()), (double)headPosX, (double)headPosY, (double)headPosZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public Item getSkull() {
        return (Item)IafItems.DRAGON_SKULL_FIRE.get();
    }

    @Override
    public Item getBloodItem() {
        return (Item)IafItems.FIRE_DRAGON_BLOOD.get();
    }

    @Override
    public Item getFleshItem() {
        return (Item)IafItems.FIRE_DRAGON_FLESH.get();
    }

    @Override
    public ItemLike getHeartItem() {
        return (ItemLike)IafItems.FIRE_DRAGON_HEART.get();
    }
}

