/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import com.iafenvoy.iceandfire.entity.EntitySiren;
import com.iafenvoy.iceandfire.entity.util.IHearsSiren;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SirenData
extends NeedUpdateData {
    public EntitySiren charmedBy;
    public int charmTime;
    public boolean isCharmed;
    private UUID charmedByUUID;
    private int charmedById;
    private boolean isInitialized;

    public void tickCharmed(LivingEntity holder) {
        if (!(holder instanceof Player || holder instanceof AbstractVillager || holder instanceof IHearsSiren)) {
            return;
        }
        if (!this.isInitialized) {
            this.initialize(holder.level());
        }
        if (this.charmedBy == null) {
            return;
        }
        if (this.charmedBy.isActuallySinging()) {
            Player player;
            if (EntitySiren.isWearingEarplugs(holder) || this.charmTime > (Integer)IafCommonConfig.INSTANCE.siren.maxSingTime.getValue()) {
                this.charmedBy.singCooldown = (Integer)IafCommonConfig.INSTANCE.siren.timeBetweenSongs.getValue();
                this.clearCharm();
                return;
            }
            if (!this.charmedBy.isAlive() || holder.distanceTo((Entity)this.charmedBy) > 64.0f || holder instanceof Player && ((player = (Player)holder).isCreative() || player.isSpectator())) {
                this.clearCharm();
                return;
            }
            if (holder.distanceTo((Entity)this.charmedBy) < 5.0f) {
                this.charmedBy.singCooldown = (Integer)IafCommonConfig.INSTANCE.siren.timeBetweenSongs.getValue();
                this.charmedBy.setSinging(false);
                this.charmedBy.setTarget(holder);
                this.charmedBy.setAggressive(true);
                this.charmedBy.triggerOtherSirens(holder);
                this.clearCharm();
                return;
            }
            this.isCharmed = true;
            ++this.charmTime;
            if (holder.getRandom().nextInt(7) == 0) {
                for (int i = 0; i < 5; ++i) {
                    holder.level().addParticle((ParticleOptions)ParticleTypes.HEART, holder.getX() + (holder.getRandom().nextDouble() - 0.5) * 3.0, holder.getY() + (holder.getRandom().nextDouble() - 0.5) * 3.0, holder.getZ() + (holder.getRandom().nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0);
                }
            }
            if (holder.horizontalCollision) {
                holder.setJumping(true);
            }
            double motionXAdd = (Math.signum(this.charmedBy.getX() - holder.getX()) * 0.5 - holder.getDeltaMovement().x) * 0.100000000372529;
            double motionYAdd = (Math.signum(this.charmedBy.getY() - holder.getY() + 1.0) * 0.5 - holder.getDeltaMovement().y) * 0.100000000372529;
            double motionZAdd = (Math.signum(this.charmedBy.getZ() - holder.getZ()) * 0.5 - holder.getDeltaMovement().z) * 0.100000000372529;
            holder.setDeltaMovement(holder.getDeltaMovement().add(motionXAdd, motionYAdd, motionZAdd));
            if (holder.isPassenger()) {
                holder.stopRiding();
            }
            if (!(holder instanceof Player)) {
                double x = this.charmedBy.getX() - holder.getX();
                double y = this.charmedBy.getY() - 1.0 - holder.getY();
                double z = this.charmedBy.getZ() - holder.getZ();
                double radius = Math.sqrt(x * x + z * z);
                float xRot = (float)(-(Mth.atan2((double)y, (double)radius) * 57.29577951308232));
                float yRot = (float)(Mth.atan2((double)z, (double)x) * 57.29577951308232) - 90.0f;
                holder.setXRot(this.updateRotation(holder.getXRot(), xRot));
                holder.setYRot(this.updateRotation(holder.getYRot(), yRot));
            }
        }
    }

    public void setCharmed(Entity entity) {
        if (!(entity instanceof EntitySiren)) {
            return;
        }
        EntitySiren siren = (EntitySiren)entity;
        this.charmedBy = siren;
        this.isCharmed = true;
        this.triggerUpdate();
    }

    public void clearCharm() {
        this.charmTime = 0;
        this.isCharmed = false;
        this.charmedBy = null;
        this.triggerUpdate();
    }

    public void serialize(CompoundTag tag) {
        CompoundTag sirenData = new CompoundTag();
        if (this.charmedBy != null) {
            sirenData.put("charmedByUUID", (Tag)NbtUtils.createUUID((UUID)this.charmedBy.getUUID()));
            sirenData.putInt("charmedById", this.charmedBy.getId());
        } else {
            sirenData.putInt("charmedById", -1);
        }
        sirenData.putInt("charmTime", this.charmTime);
        sirenData.putBoolean("isCharmed", this.isCharmed);
        tag.put("sirenData", (Tag)sirenData);
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag sirenData = tag.getCompound("sirenData");
        Tag uuidTag = sirenData.get("charmedByUUID");
        if (uuidTag != null) {
            this.charmedByUUID = NbtUtils.loadUUID((Tag)uuidTag);
        }
        this.charmedById = sirenData.getInt("charmedById");
        this.charmTime = sirenData.getInt("charmTime");
        this.isCharmed = sirenData.getBoolean("isCharmed");
        this.isInitialized = false;
    }

    private float updateRotation(float angle, float targetAngle) {
        float f = Mth.wrapDegrees((float)(targetAngle - angle));
        if (f > 30.0f) {
            f = 30.0f;
        }
        if (f < -30.0f) {
            f = -30.0f;
        }
        return angle + f;
    }

    private void initialize(Level level) {
        Entity entity;
        this.charmedBy = null;
        if (this.charmedByUUID != null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity2 = serverLevel.getEntity(this.charmedByUUID);
            if (entity2 instanceof EntitySiren) {
                EntitySiren siren = (EntitySiren)entity2;
                this.triggerUpdate();
                this.charmedByUUID = null;
                this.charmedBy = siren;
            }
        } else if (this.charmedById != -1 && (entity = level.getEntity(this.charmedById)) instanceof EntitySiren) {
            EntitySiren siren;
            this.charmedBy = siren = (EntitySiren)entity;
        }
        this.isInitialized = true;
    }
}

