/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class FrozenData
extends NeedUpdateData {
    public int frozenTicks;
    public boolean isFrozen;

    public void tickFrozen(LivingEntity entity) {
        Player player;
        if (!this.isFrozen) {
            return;
        }
        if (entity instanceof EntityIceDragon) {
            this.clearFrozen(entity);
            return;
        }
        if (entity.isOnFire()) {
            this.clearFrozen(entity);
            entity.clearFire();
            return;
        }
        if (entity.isDeadOrDying()) {
            this.clearFrozen(entity);
            return;
        }
        if (this.frozenTicks > 0) {
            --this.frozenTicks;
        } else {
            this.clearFrozen(entity);
        }
        if (!(!this.isFrozen || entity instanceof Player && (player = (Player)entity).isCreative())) {
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.25, 1.0, 0.25));
            if (!(entity instanceof EnderDragon) && !entity.onGround()) {
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, -0.2, 0.0));
            }
        }
    }

    public void setFrozen(LivingEntity target, int duration) {
        if (!this.isFrozen) {
            target.playSound(SoundEvents.GLASS_PLACE, 1.0f, 1.0f);
        }
        this.frozenTicks = duration;
        this.isFrozen = true;
        this.triggerUpdate();
    }

    private void clearFrozen(LivingEntity entity) {
        for (int i = 0; i < 15; ++i) {
            entity.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((Block)IafBlocks.DRAGON_ICE.get()).defaultBlockState()), entity.getX() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth(), entity.getY() + entity.getRandom().nextDouble() * (double)entity.getBbHeight(), entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * (double)entity.getBbWidth(), 0.0, 0.0, 0.0);
        }
        entity.playSound(SoundEvents.GLASS_BREAK, 3.0f, 1.0f);
        this.isFrozen = false;
        this.frozenTicks = 0;
        this.triggerUpdate();
    }

    public void serialize(CompoundTag tag) {
        CompoundTag frozenData = new CompoundTag();
        frozenData.putInt("frozenTicks", this.frozenTicks);
        frozenData.putBoolean("isFrozen", this.isFrozen);
        tag.put("frozenData", (Tag)frozenData);
    }

    public void deserialize(CompoundTag tag) {
        CompoundTag frozenData = tag.getCompound("frozenData");
        this.frozenTicks = frozenData.getInt("frozenTicks");
        this.isFrozen = frozenData.getBoolean("isFrozen");
    }
}

