/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.compat.jei;

import com.iafenvoy.iceandfire.compat.jei.FireDragonForgeRecipeCategory;
import com.iafenvoy.iceandfire.compat.jei.IceDragonForgeRecipeCategory;
import com.iafenvoy.iceandfire.compat.jei.LightningDragonForgeRecipeCategory;
import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class IceAndFireJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"iceandfire");
    public static final RecipeType<DragonForgeRecipe> FIRE = RecipeType.create((String)"minecraft", (String)"firedragonforge", DragonForgeRecipe.class);
    public static final RecipeType<DragonForgeRecipe> ICE = RecipeType.create((String)"minecraft", (String)"icedragonforge", DragonForgeRecipe.class);
    public static final RecipeType<DragonForgeRecipe> LIGHTNING = RecipeType.create((String)"minecraft", (String)"lightningdragonforge", DragonForgeRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FireDragonForgeRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new IceDragonForgeRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new LightningDragonForgeRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)IafBlocks.DRAGONFORGE_FIRE_CORE.get(), new RecipeType[]{FIRE});
        registration.addRecipeCatalyst((ItemLike)IafBlocks.DRAGONFORGE_ICE_CORE.get(), new RecipeType[]{ICE});
        registration.addRecipeCatalyst((ItemLike)IafBlocks.DRAGONFORGE_LIGHTNING_CORE.get(), new RecipeType[]{LIGHTNING});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List recipeList = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)IafRecipes.DRAGON_FORGE_TYPE.get());
        ArrayList<DragonForgeRecipe> FIRE_RECIPES = new ArrayList<DragonForgeRecipe>();
        ArrayList<DragonForgeRecipe> ICE_RECIPES = new ArrayList<DragonForgeRecipe>();
        ArrayList<DragonForgeRecipe> LIGHTNING_RECIPES = new ArrayList<DragonForgeRecipe>();
        for (RecipeHolder recipe : recipeList) {
            switch (((DragonForgeRecipe)recipe.value()).getDragonType()) {
                case "fire": {
                    FIRE_RECIPES.add((DragonForgeRecipe)recipe.value());
                    break;
                }
                case "ice": {
                    ICE_RECIPES.add((DragonForgeRecipe)recipe.value());
                    break;
                }
                case "lightning": {
                    LIGHTNING_RECIPES.add((DragonForgeRecipe)recipe.value());
                }
            }
        }
        registration.addRecipes(FIRE, FIRE_RECIPES);
        registration.addRecipes(ICE, ICE_RECIPES);
        registration.addRecipes(LIGHTNING, LIGHTNING_RECIPES);
    }
}

