/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.recipe;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.lib.colour.EnumColour;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.covers1624.quack.collection.ColUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ReColourRecipe
implements CraftingRecipe {
    protected final String group;
    protected final ItemStack result;
    protected final Ingredient ingredient;

    public ReColourRecipe(ItemStack result) {
        this("", result);
    }

    public ReColourRecipe(String group, ItemStack result) {
        this.group = group;
        this.result = result;
        this.ingredient = Ingredient.of((ItemStack[])new ItemStack[]{result});
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        if (inv.isEmpty()) {
            return false;
        }
        ItemWithPos chest = this.findChest(inv);
        if (chest == null || chest.y == 0) {
            return false;
        }
        ArrayList<ItemWithPos> validPositions = new ArrayList<ItemWithPos>();
        validPositions.add(chest);
        EnumColour[] colours = this.findDyes(inv, chest, validPositions);
        if (colours == null) {
            return false;
        }
        for (int x = 0; x < inv.width(); ++x) {
            for (int y = 0; y < inv.height(); ++y) {
                ItemStack stack = inv.getItem(x + y * inv.width());
                if (stack.isEmpty() || validPositions.contains(new ItemWithPos(x, y, stack))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemWithPos chestPos = this.findChest(inv);
        if (chestPos == null) {
            return this.result.copy();
        }
        EnumColour[] colours = this.findDyes(inv, chestPos, null);
        if (colours == null) {
            return this.result.copy();
        }
        return Frequency.readFromStack(chestPos.stack).withColours(colours).writeToStack(this.result.copy());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EnderStorageModContent.RECOLOUR_RECIPE_SERIALIZER.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public String getGroup() {
        return this.group;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    @Nullable
    private ItemWithPos findChest(CraftingInput inv) {
        ItemWithPos chest = null;
        block0: for (int x = 0; x < inv.width(); ++x) {
            for (int y = 0; y < inv.height(); ++y) {
                ItemStack stack = inv.getItem(x, y);
                if (stack.isEmpty() || !this.ingredient.test(stack)) continue;
                chest = new ItemWithPos(x, y, stack);
                continue block0;
            }
        }
        return chest;
    }

    private EnumColour @Nullable [] findDyes(CraftingInput inv, ItemWithPos chest, @Nullable List<ItemWithPos> validPositions) {
        Object[] colours = new EnumColour[]{null, null, null};
        for (int x = 0; x < inv.width(); ++x) {
            for (int y = 0; y < chest.y; ++y) {
                int effectiveColour;
                EnumColour colour;
                ItemStack stack = inv.getItem(x, y);
                if (stack.isEmpty() || (colour = EnumColour.fromDyeStack((ItemStack)stack)) == null) continue;
                int n = chest.x == x ? 1 : (effectiveColour = chest.x < x ? 2 : 0);
                if (colours[effectiveColour] != null) {
                    EnumColour merge = EnumColour.mix((EnumColour)colours[effectiveColour], (EnumColour)colour);
                    if (merge == null || merge == colour) {
                        return null;
                    }
                    colours[effectiveColour] = merge;
                } else {
                    colours[effectiveColour] = colour;
                }
                if (validPositions == null) continue;
                validPositions.add(new ItemWithPos(x, y, stack));
            }
        }
        return !ColUtils.allMatch((Object[])colours, Objects::isNull) ? colours : null;
    }

    private record ItemWithPos(int x, int y, ItemStack stack) {
    }

    public static class Serializer
    implements RecipeSerializer<ReColourRecipe> {
        private static final MapCodec<ReColourRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(e -> e.group), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(e -> e.result)).apply((Applicative)builder, ReColourRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ReColourRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, e -> e.group, (StreamCodec)ItemStack.STREAM_CODEC, e -> e.result, ReColourRecipe::new);

        public MapCodec<ReColourRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ReColourRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

