/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.mixin;

import com.google.common.base.Objects;
import fuzs.blockrunner.world.level.block.data.BlockSpeed;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity {
    @Shadow
    private BlockPos lastPos;

    public LivingEntityMixin(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getBlockSpeedFactor(CallbackInfoReturnable<Float> callback) {
        if (BlockSpeed.hasBlockSpeed(this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock())) {
            callback.setReturnValue((Object)Float.valueOf(1.0f));
        }
    }

    @Inject(method={"onChangedBlock"}, at={@At(value="TAIL")})
    protected void onChangedBlock(ServerLevel level, BlockPos pos, CallbackInfo callback) {
        this.blockrunner$onChangedBlock();
    }

    @Inject(method={"checkFallDamage"}, at={@At(value="HEAD")})
    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos, CallbackInfo callback) {
        if ((!this.level().isClientSide || LivingEntity.class.cast((Object)this) instanceof Player) && onGround && this.fallDistance > 0.0f) {
            this.blockrunner$removeBlockSpeed();
            this.blockrunner$tryAddBlockSpeed();
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public void baseTick(CallbackInfo callback) {
        BlockPos blockPos;
        if (this.level().isClientSide && LivingEntity.class.cast((Object)this) instanceof Player && !Objects.equal((Object)this.lastPos, (Object)(blockPos = this.blockPosition()))) {
            this.lastPos = blockPos;
            this.blockrunner$onChangedBlock();
        }
    }

    @Unique
    private void blockrunner$onChangedBlock() {
        block3: {
            block2: {
                if (!this.getBlockStateOn().isAir() || this.isFallFlying()) break block2;
                Object t = LivingEntity.class.cast((Object)this);
                if (!(t instanceof Player)) break block3;
                Player player = (Player)t;
                if (!player.getAbilities().flying) break block3;
            }
            this.blockrunner$removeBlockSpeed();
        }
        this.blockrunner$tryAddBlockSpeed();
    }

    @Unique
    private void blockrunner$removeBlockSpeed() {
        AttributeInstance attribute = this.getAttribute((Holder<Attribute>)Attributes.MOVEMENT_SPEED);
        if (attribute != null && attribute.getModifier(BlockSpeed.SPEED_MODIFIER_BLOCK_SPEED_IDENTIFIER) != null) {
            attribute.removeModifier(BlockSpeed.SPEED_MODIFIER_BLOCK_SPEED_IDENTIFIER);
        }
    }

    @Unique
    protected void blockrunner$tryAddBlockSpeed() {
        block6: {
            BlockState blockState;
            block5: {
                Object t = LivingEntity.class.cast((Object)this);
                if (!(t instanceof Player)) break block5;
                Player player = (Player)t;
                if (player.getAbilities().flying) break block6;
            }
            if (!(blockState = this.getBlockStateOn()).isAir()) {
                double speedFactor = BlockSpeed.getSpeedFactor(blockState.getBlock());
                AttributeInstance attribute = this.getAttribute((Holder<Attribute>)Attributes.MOVEMENT_SPEED);
                if (attribute == null || speedFactor == 1.0) {
                    return;
                }
                double baseValue = attribute.getBaseValue();
                speedFactor = speedFactor * baseValue - baseValue;
                attribute.addTransientModifier(new AttributeModifier(BlockSpeed.SPEED_MODIFIER_BLOCK_SPEED_IDENTIFIER, speedFactor, AttributeModifier.Operation.ADD_VALUE));
            }
        }
    }

    @Shadow
    public abstract AttributeInstance getAttribute(Holder<Attribute> var1);

    @Shadow
    public abstract boolean isFallFlying();
}

