/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.experiencelib.util;

import com.google.common.primitives.Ints;
import es.degrassi.experiencelib.ExperienceLib;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;

public class ExperienceUtils {
    public static final Material EXPERIENCE = new Material(InventoryMenu.BLOCK_ATLAS, ExperienceLib.rl("block/experience"));
    public static final ResourceLocation EXPERIENCE_GUI = ExperienceLib.rl("textures/gui/experience.png");
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("#,###");

    public static String format(int number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String format(long number) {
        return NUMBER_FORMAT.format(number);
    }

    public static String format(double number) {
        return NUMBER_FORMAT.format(number);
    }

    public static long getXpNeededForNextLevel(long currentLevel) {
        if (currentLevel >= 30L) {
            return 112L + (currentLevel - 30L) * 9L;
        }
        if (currentLevel >= 15L) {
            return 37L + (currentLevel - 15L) * 5L;
        }
        return 7L + currentLevel * 2L;
    }

    public static long getXpFromLevel(long level) {
        if (level >= 32L) {
            return (long)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        if (level >= 17L) {
            return (long)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (long)(Math.pow(level, 2.0) + (double)(6L * level));
    }

    public static long getLevelFromXp(long experience) {
        if (experience >= 1508L) {
            return (int)(18.055555555555557 + Math.sqrt(0.2222222222222222 * ((double)experience - 752.9861111111111)));
        }
        if (experience >= 353L) {
            return (int)(8.1 + Math.sqrt(0.4 * ((double)experience - 195.975)));
        }
        return (int)(Math.sqrt(experience + 9L) - 3.0);
    }

    public static long getPlayerTotalXp(Player player) {
        return ExperienceUtils.getXpFromLevel(player.experienceLevel) + (long)Math.floor(player.experienceProgress * (float)ExperienceUtils.getXpNeededForNextLevel(player.experienceLevel));
    }

    public static void addLevelToPlayer(IExperienceHandler handler, int levelDiff, Player player) {
        int requestedLevel = player.experienceLevel + levelDiff;
        requestedLevel = Math.max(requestedLevel, 0);
        long playerXP = ExperienceUtils.getPlayerTotalXp(player);
        long requestedXP = ExperienceUtils.getXpFromLevel(requestedLevel) - playerXP;
        long awardXP = levelDiff > 0 ? Math.min(handler.getExperience(), requestedXP) : -Math.min(Math.abs(requestedXP), handler.getExperienceCapacity() - handler.getExperience());
        ExperienceUtils.awardXP(handler, Ints.saturatedCast((long)awardXP), player);
    }

    public static void addAllLevelToPlayer(IExperienceHandler handler, boolean give, Player player) {
        int awardXP = give ? Ints.saturatedCast((long)handler.getExperience()) : -Ints.saturatedCast((long)Math.min(ExperienceUtils.getPlayerTotalXp(player), handler.getExperienceCapacity() - handler.getExperience()));
        ExperienceUtils.awardXP(handler, awardXP, player);
    }

    public static void awardXP(IExperienceHandler handler, int xp, Player player) {
        if (xp > 0) {
            handler.extractExperience(xp, false);
        } else {
            handler.receiveExperience(Math.abs(xp), false);
        }
        player.giveExperiencePoints(xp);
    }
}

