/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen.data;

import java.util.List;
import java.util.stream.Collectors;
import net.allthemods.alltheores.content.blocks.ore.OreBlock;
import net.allthemods.alltheores.content.blocks.sets.ATOSetHelper;
import net.allthemods.alltheores.registry.ATORegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class ATOLootTableProvider
extends VanillaBlockLoot {
    public ATOLootTableProvider(HolderLookup.Provider provider) {
        super(provider);
    }

    public void generate() {
        ATOSetHelper.applyToOre(set -> List.of(set.STONE_ORE_BLOCK, set.SLATE_ORE_BLOCK, set.NETHER_ORE_BLOCK, set.END_ORE_BLOCK, set.OTHER_ORE_BLOCK).forEach(blockHolder -> this.add((Block)blockHolder.get(), block -> this.createOreDrop((Block)block, (Item)set.DROP.get()))));
        this.getKnownBlocks().forEach(this::dropBlock);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        return ATORegistry.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(block -> !(block instanceof LiquidBlock)).collect(Collectors.toList());
    }

    private void dropBlock(Block block) {
        if (block instanceof OreBlock) {
            return;
        }
        this.dropSelf(block);
    }
}

