/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelpigail<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"astral_dimension", (String)"modelpigail"), "main");
    public final ModelPart head;
    public final ModelPart l_leg_1;
    public final ModelPart r_leg_1;
    public final ModelPart l_leg_2;
    public final ModelPart r_leg_2;
    public final ModelPart bb_main;

    public Modelpigail(ModelPart root) {
        this.head = root.getChild("head");
        this.l_leg_1 = root.getChild("l_leg_1");
        this.r_leg_1 = root.getChild("r_leg_1");
        this.l_leg_2 = root.getChild("l_leg_2");
        this.r_leg_2 = root.getChild("r_leg_2");
        this.bb_main = root.getChild("bb_main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(36, 0).addBox(-4.0f, -5.2758f, -5.8462f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(5, 24).addBox(-2.0f, -1.2758f, -6.8462f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(52, 16).addBox(-4.0f, -8.2758f, -13.8462f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(52, 16).addBox(1.0f, -8.2758f, -13.8462f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.2758f, (float)-8.1538f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-8.5f, -1.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.5f, -1.5f, -2.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)-4.7758f, (float)-9.8462f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(46, 6).addBox(-5.5f, -4.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(31, 16).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-2.2758f, (float)-5.3462f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition l_leg_1 = partdefinition.addOrReplaceChild("l_leg_1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)18.0f, (float)-6.0f));
        PartDefinition r_leg_1 = partdefinition.addOrReplaceChild("r_leg_1", CubeListBuilder.create().texOffs(30, 24).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)18.0f, (float)-6.0f));
        PartDefinition l_leg_2 = partdefinition.addOrReplaceChild("l_leg_2", CubeListBuilder.create().texOffs(44, 30).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)18.0f, (float)6.0f));
        PartDefinition r_leg_2 = partdefinition.addOrReplaceChild("r_leg_2", CubeListBuilder.create().texOffs(44, 40).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)18.0f, (float)6.0f));
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -14.0f, -8.0f, 10.0f, 8.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(-4.0f, -25.0f, -5.0f, 8.0f, 11.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.l_leg_1.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.r_leg_1.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.l_leg_2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.r_leg_2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.l_leg_2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.r_leg_2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.l_leg_1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.r_leg_1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

