/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelhelioos<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"astral_dimension", (String)"modelhelioos"), "main");
    public final ModelPart l_hand;
    public final ModelPart r_hand;
    public final ModelPart head;
    public final ModelPart l_leg;
    public final ModelPart r_leg;
    public final ModelPart bb_main;

    public Modelhelioos(ModelPart root) {
        this.l_hand = root.getChild("l_hand");
        this.r_hand = root.getChild("r_hand");
        this.head = root.getChild("head");
        this.l_leg = root.getChild("l_leg");
        this.r_leg = root.getChild("r_leg");
        this.bb_main = root.getChild("bb_main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition l_hand = partdefinition.addOrReplaceChild("l_hand", CubeListBuilder.create().texOffs(40, 0).addBox(-3.0f, -0.5f, -2.5f, 6.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)1.5f, (float)-0.5f));
        PartDefinition r_hand = partdefinition.addOrReplaceChild("r_hand", CubeListBuilder.create().texOffs(30, 33).addBox(-3.0f, -0.5f, -2.5f, 6.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)1.5f, (float)-0.5f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.1667f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 20).addBox(-5.0f, -13.1667f, -5.0f, 10.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 51).addBox(-3.0f, -16.1667f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.1667f, (float)-1.0f));
        PartDefinition l_leg = partdefinition.addOrReplaceChild("l_leg", CubeListBuilder.create().texOffs(24, 51).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)14.0f, (float)-0.5f));
        PartDefinition r_leg = partdefinition.addOrReplaceChild("r_leg", CubeListBuilder.create().texOffs(24, 51).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.5f, (float)14.0f, (float)-0.5f));
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(0, 33).addBox(-5.0f, -23.0f, -3.0f, 10.0f, 13.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = bb_main.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(40, 24).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-23.0f, (float)2.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = bb_main.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(40, 18).addBox(-5.0f, 0.0f, -7.0f, 10.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-25.0f, (float)-2.0f, (float)0.9599f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)68, (int)66);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.l_hand.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.r_hand.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.l_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.r_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.r_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.l_hand.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.l_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.r_hand.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
    }
}

