/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.astraldimension.block;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.astraldimension.init.AstralDimensionModBlockEntities;
import net.mcreator.astraldimension.init.AstralDimensionModBlocks;
import net.mcreator.astraldimension.procedures.LucidBellRingingOnTickUpdateProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LucidBellRingingBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final IntegerProperty ANIMATION = IntegerProperty.create((String)"animation", (int)0, (int)1);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<LucidBellRingingBlock> CODEC = LucidBellRingingBlock.simpleCodec(properties -> new LucidBellRingingBlock());

    public MapCodec<LucidBellRingingBlock> codec() {
        return CODEC;
    }

    public LucidBellRingingBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.ANVIL).strength(4.0f, 3.0f).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)AstralDimensionModBlockEntities.LUCID_BELL_RINGING.get()).create(blockPos, blockState);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)LucidBellRingingBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LucidBellRingingBlock.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), LucidBellRingingBlock.box((double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)16.0, (double)11.0), LucidBellRingingBlock.box((double)14.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0), LucidBellRingingBlock.box((double)2.0, (double)13.0, (double)7.0, (double)14.0, (double)15.0, (double)9.0), LucidBellRingingBlock.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)LucidBellRingingBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LucidBellRingingBlock.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), LucidBellRingingBlock.box((double)14.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)11.0), LucidBellRingingBlock.box((double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)16.0, (double)11.0), LucidBellRingingBlock.box((double)2.0, (double)13.0, (double)7.0, (double)14.0, (double)15.0, (double)9.0), LucidBellRingingBlock.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)LucidBellRingingBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LucidBellRingingBlock.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), LucidBellRingingBlock.box((double)5.0, (double)0.0, (double)14.0, (double)11.0, (double)16.0, (double)16.0), LucidBellRingingBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)2.0), LucidBellRingingBlock.box((double)7.0, (double)13.0, (double)2.0, (double)9.0, (double)15.0, (double)14.0), LucidBellRingingBlock.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)LucidBellRingingBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), (VoxelShape[])new VoxelShape[]{LucidBellRingingBlock.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), LucidBellRingingBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)2.0), LucidBellRingingBlock.box((double)5.0, (double)0.0, (double)14.0, (double)11.0, (double)16.0, (double)16.0), LucidBellRingingBlock.box((double)7.0, (double)13.0, (double)2.0, (double)9.0, (double)15.0, (double)14.0), LucidBellRingingBlock.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)8.0, (double)9.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ANIMATION, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)AstralDimensionModBlocks.LUCID_BELL.get());
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List dropsOriginal = super.getDrops(state, builder);
        if (!dropsOriginal.isEmpty()) {
            return dropsOriginal;
        }
        return Collections.singletonList(new ItemStack((ItemLike)AstralDimensionModBlocks.LUCID_BELL.get()));
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 100);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        LucidBellRingingOnTickUpdateProcedure.execute((LevelAccessor)world, x, y, z);
        world.scheduleTick(pos, (Block)this, 100);
    }
}

