/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import codechicken.lib.datagen.ItemModelProvider;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.client.render.item.RenderItemChaosShard;
import com.brandon3055.draconicevolution.client.render.item.RenderItemDraconiumChest;
import com.brandon3055.draconicevolution.client.render.item.RenderItemEnergyCrystal;
import com.brandon3055.draconicevolution.client.render.item.RenderItemMobSoul;
import com.brandon3055.draconicevolution.client.render.item.RenderItemReactorComponent;
import com.brandon3055.draconicevolution.client.render.item.RenderModularAxe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularBow;
import com.brandon3055.draconicevolution.client.render.item.RenderModularChestpiece;
import com.brandon3055.draconicevolution.client.render.item.RenderModularHoe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularPickaxe;
import com.brandon3055.draconicevolution.client.render.item.RenderModularShovel;
import com.brandon3055.draconicevolution.client.render.item.RenderModularStaff;
import com.brandon3055.draconicevolution.client.render.item.RenderModularSword;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEModules;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "draconicevolution", existingFileHelper);
    }

    protected void registerModels() {
        this.blockItem(DEContent.GENERATOR, this.modLoc("block/generator/generator"));
        this.blockItem(DEContent.GRINDER, this.modLoc("block/grinder/grinder"));
        this.blockItem(DEContent.ENERGY_PYLON, this.modLoc("block/energy_pylon_input"));
        this.blockItem(DEContent.CRAFTING_CORE, this.modLoc("block/crafting/fusion_crafting_core"));
        this.blockItem(DEContent.BASIC_CRAFTING_INJECTOR, this.modLoc("block/crafting/crafting_injector_draconium"));
        this.blockItem(DEContent.WYVERN_CRAFTING_INJECTOR, this.modLoc("block/crafting/crafting_injector_wyvern"));
        this.blockItem(DEContent.AWAKENED_CRAFTING_INJECTOR, this.modLoc("block/crafting/crafting_injector_draconic"));
        this.blockItem(DEContent.CHAOTIC_CRAFTING_INJECTOR, this.modLoc("block/crafting/crafting_injector_chaotic"));
        this.blockItem(DEContent.FLUID_GATE);
        this.blockItem(DEContent.FLUX_GATE);
        this.blockItem(DEContent.POTENTIOMETER);
        this.blockItem(DEContent.DISENCHANTER);
        this.blockItem(DEContent.ENERGY_TRANSFUSER, this.modLoc("block/energy_transfuser"));
        this.blockItem(DEContent.DISLOCATOR_PEDESTAL);
        this.blockItem(DEContent.DISLOCATOR_RECEPTACLE, this.modLoc("block/dislocator_receptacle_inactive"));
        this.blockItem(DEContent.CREATIVE_OP_CAPACITOR);
        this.blockItem(DEContent.ENTITY_DETECTOR);
        this.blockItem(DEContent.ENTITY_DETECTOR_ADVANCED);
        this.blockItem(DEContent.STABILIZED_SPAWNER);
        this.blockItem(DEContent.CELESTIAL_MANIPULATOR);
        this.blockItem(DEContent.DRACONIUM_CHEST);
        this.blockItem(DEContent.PARTICLE_GENERATOR);
        this.dummyBlock(DEContent.PLACED_ITEM);
        this.blockItem(DEContent.PORTAL);
        this.blockItem(DEContent.CHAOS_CRYSTAL);
        this.blockItem(DEContent.ENERGY_CORE);
        this.blockItem(DEContent.ENERGY_CORE_STABILIZER);
        this.blockItem(DEContent.STRUCTURE_BLOCK);
        this.blockItem(DEContent.REACTOR_CORE);
        this.blockItem(DEContent.REACTOR_STABILIZER);
        this.blockItem(DEContent.REACTOR_INJECTOR);
        this.blockItem(DEContent.RAIN_SENSOR);
        this.blockItem(DEContent.DISLOCATION_INHIBITOR);
        this.blockItem(DEContent.OVERWORLD_DRACONIUM_ORE);
        this.blockItem(DEContent.NETHER_DRACONIUM_ORE);
        this.blockItem(DEContent.END_DRACONIUM_ORE);
        this.blockItem(DEContent.DEEPSLATE_DRACONIUM_ORE);
        this.blockItem(DEContent.DRACONIUM_BLOCK);
        this.blockItem(DEContent.AWAKENED_DRACONIUM_BLOCK);
        this.blockItem(DEContent.INFUSED_OBSIDIAN);
        this.dummyBlock(DEContent.BASIC_IO_CRYSTAL);
        this.dummyBlock(DEContent.WYVERN_IO_CRYSTAL);
        this.dummyBlock(DEContent.DRACONIC_IO_CRYSTAL);
        this.dummyBlock(DEContent.BASIC_RELAY_CRYSTAL);
        this.dummyBlock(DEContent.WYVERN_RELAY_CRYSTAL);
        this.dummyBlock(DEContent.DRACONIC_RELAY_CRYSTAL);
        this.dummyBlock(DEContent.BASIC_WIRELESS_CRYSTAL);
        this.dummyBlock(DEContent.WYVERN_WIRELESS_CRYSTAL);
        this.dummyBlock(DEContent.DRACONIC_WIRELESS_CRYSTAL);
        this.simpleItem(DEContent.DUST_DRACONIUM, "item/components");
        this.simpleItem(DEContent.DUST_DRACONIUM_AWAKENED, "item/components");
        this.simpleItem(DEContent.INGOT_DRACONIUM, "item/components");
        this.simpleItem(DEContent.INGOT_DRACONIUM_AWAKENED, "item/components");
        this.simpleItem(DEContent.NUGGET_DRACONIUM, "item/components");
        this.simpleItem(DEContent.NUGGET_DRACONIUM_AWAKENED, "item/components");
        this.simpleItem(DEContent.CORE_DRACONIUM, "item/components");
        this.simpleItem(DEContent.CORE_WYVERN, "item/components");
        this.simpleItem(DEContent.CORE_AWAKENED, "item/components");
        this.simpleItem(DEContent.CORE_CHAOTIC, "item/components");
        this.simpleItem(DEContent.ENERGY_CORE_WYVERN, "item/components");
        this.simpleItem(DEContent.ENERGY_CORE_DRACONIC, "item/components");
        this.simpleItem(DEContent.ENERGY_CORE_CHAOTIC, "item/components");
        this.simpleItem(DEContent.DRAGON_HEART, "item/components");
        this.simpleItem(DEContent.MODULE_CORE, "item/components");
        this.dummyItem(DEContent.CHAOS_SHARD);
        this.dummyItem(DEContent.CHAOS_FRAG_SMALL);
        this.dummyItem(DEContent.CHAOS_FRAG_MEDIUM);
        this.dummyItem(DEContent.CHAOS_FRAG_LARGE);
        this.dummyItem(DEContent.REACTOR_PRT_STAB_FRAME);
        this.dummyItem(DEContent.REACTOR_PRT_IN_ROTOR);
        this.dummyItem(DEContent.REACTOR_PRT_OUT_ROTOR);
        this.dummyItem(DEContent.REACTOR_PRT_ROTOR_FULL);
        this.dummyItem(DEContent.REACTOR_PRT_FOCUS_RING);
        this.dummyBlock(DEContent.DRACONIUM_CHEST);
        this.dummyBlock(DEContent.REACTOR_CORE);
        this.dummyBlock(DEContent.REACTOR_STABILIZER);
        this.dummyBlock(DEContent.REACTOR_INJECTOR);
        this.dummyItem(DEContent.MOB_SOUL);
        this.simpleItem(DEContent.MAGNET);
        this.simpleItem(DEContent.MAGNET_ADVANCED);
        this.simpleItem(DEContent.DISLOCATOR);
        this.simpleItem(DEContent.DISLOCATOR_ADVANCED);
        this.simpleItem(DEContent.DISLOCATOR_P2P, this.modLoc("item/bound_dislocator"));
        this.simpleItem(DEContent.DISLOCATOR_P2P_UNBOUND, this.modLoc("item/un_bound_dislocator"));
        this.simpleItem(DEContent.DISLOCATOR_PLAYER, this.modLoc("item/bound_dislocator"));
        this.simpleItem(DEContent.DISLOCATOR_PLAYER_UNBOUND, this.modLoc("item/bound_dislocator"));
        this.simpleItem(DEContent.CRYSTAL_BINDER);
        this.simpleItem(DEContent.INFO_TABLET);
        DEModules.MODULES.getEntries().stream().filter(e -> e.getId().getNamespace().equals("draconicevolution")).forEach(module -> {
            String name = Objects.requireNonNull(module.getId()).getPath();
            ResourceLocation baseTexture = ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("item/module/" + ((Module)module.get()).getModuleTechLevel().name().toLowerCase(Locale.ENGLISH)));
            ResourceLocation overlay = ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("module/" + name));
            this.multiLayerItem(((Module)module.get()).getItem(), baseTexture, overlay);
        });
        this.simpleItem(DEContent.CAPACITOR_WYVERN, "item/tools");
        this.simpleItem(DEContent.CAPACITOR_DRACONIC, "item/tools");
        this.simpleItem(DEContent.CAPACITOR_CHAOTIC, "item/tools");
        this.simpleItem(DEContent.CAPACITOR_CREATIVE, "item/tools");
        this.clazz((Supplier)DEContent.CHAOS_SHARD, RenderItemChaosShard.CHAOS_SHARD.class);
        this.clazz((Supplier)DEContent.CHAOS_FRAG_LARGE, RenderItemChaosShard.CHAOS_FRAG_LARGE.class);
        this.clazz((Supplier)DEContent.CHAOS_FRAG_MEDIUM, RenderItemChaosShard.CHAOS_FRAG_MEDIUM.class);
        this.clazz((Supplier)DEContent.CHAOS_FRAG_SMALL, RenderItemChaosShard.CHAOS_FRAG_SMALL.class);
        this.clazz((Supplier)DEContent.MOB_SOUL, RenderItemMobSoul.class);
        this.clazz((Supplier)DEContent.ITEM_BASIC_IO_CRYSTAL, RenderItemEnergyCrystal.ITEM_BASIC_IO_CRYSTAL.class);
        this.clazz((Supplier)DEContent.ITEM_WYVERN_IO_CRYSTAL, RenderItemEnergyCrystal.ITEM_WYVERN_IO_CRYSTAL.class);
        this.clazz((Supplier)DEContent.ITEM_DRACONIC_IO_CRYSTAL, RenderItemEnergyCrystal.ITEM_DRACONIC_IO_CRYSTAL.class);
        this.clazz((Supplier)DEContent.ITEM_BASIC_RELAY_CRYSTAL, RenderItemEnergyCrystal.ITEM_BASIC_RELAY_CRYSTAL.class);
        this.clazz((Supplier)DEContent.ITEM_WYVERN_RELAY_CRYSTAL, RenderItemEnergyCrystal.ITEM_WYVERN_RELAY_CRYSTAL.class);
        this.clazz((Supplier)DEContent.ITEM_DRACONIC_RELAY_CRYSTAL, RenderItemEnergyCrystal.ITEM_DRACONIC_RELAY_CRYSTAL.class);
        this.clazz((Supplier)DEContent.ITEM_BASIC_WIRELESS_CRYSTAL, RenderItemEnergyCrystal.ITEM_BASIC_WIRELESS_CRYSTAL.class);
        this.clazz((Supplier)DEContent.ITEM_WYVERN_WIRELESS_CRYSTAL, RenderItemEnergyCrystal.ITEM_WYVERN_WIRELESS_CRYSTAL.class);
        this.clazz((Supplier)DEContent.ITEM_DRACONIC_WIRELESS_CRYSTAL, RenderItemEnergyCrystal.ITEM_DRACONIC_WIRELESS_CRYSTAL.class);
        this.clazz((Supplier)DEContent.ITEM_DRACONIUM_CHEST, RenderItemDraconiumChest.class);
        this.clazz((Supplier)DEContent.ITEM_REACTOR_CORE, RenderItemReactorComponent.class);
        this.clazz((Supplier)DEContent.ITEM_REACTOR_STABILIZER, RenderItemReactorComponent.class);
        this.clazz((Supplier)DEContent.ITEM_REACTOR_INJECTOR, RenderItemReactorComponent.class);
        this.clazz((Supplier)DEContent.REACTOR_PRT_STAB_FRAME, RenderItemReactorComponent.class);
        this.clazz((Supplier)DEContent.REACTOR_PRT_IN_ROTOR, RenderItemReactorComponent.class);
        this.clazz((Supplier)DEContent.REACTOR_PRT_OUT_ROTOR, RenderItemReactorComponent.class);
        this.clazz((Supplier)DEContent.REACTOR_PRT_ROTOR_FULL, RenderItemReactorComponent.class);
        this.clazz((Supplier)DEContent.REACTOR_PRT_FOCUS_RING, RenderItemReactorComponent.class);
        this.clazz((Supplier)DEContent.PICKAXE_WYVERN, RenderModularPickaxe.PICKAXE_WYVERN.class);
        this.clazz((Supplier)DEContent.PICKAXE_DRACONIC, RenderModularPickaxe.PICKAXE_DRACONIC.class);
        this.clazz((Supplier)DEContent.PICKAXE_CHAOTIC, RenderModularPickaxe.PICKAXE_CHAOTIC.class);
        this.clazz((Supplier)DEContent.AXE_WYVERN, RenderModularAxe.AXE_WYVERN.class);
        this.clazz((Supplier)DEContent.AXE_DRACONIC, RenderModularAxe.AXE_DRACONIC.class);
        this.clazz((Supplier)DEContent.AXE_CHAOTIC, RenderModularAxe.AXE_CHAOTIC.class);
        this.clazz((Supplier)DEContent.SHOVEL_WYVERN, RenderModularShovel.SHOVEL_WYVERN.class);
        this.clazz((Supplier)DEContent.SHOVEL_DRACONIC, RenderModularShovel.SHOVEL_DRACONIC.class);
        this.clazz((Supplier)DEContent.SHOVEL_CHAOTIC, RenderModularShovel.SHOVEL_CHAOTIC.class);
        this.clazz((Supplier)DEContent.SWORD_WYVERN, RenderModularSword.SWORD_WYVERN.class);
        this.clazz((Supplier)DEContent.SWORD_DRACONIC, RenderModularSword.SWORD_DRACONIC.class);
        this.clazz((Supplier)DEContent.SWORD_CHAOTIC, RenderModularSword.SWORD_CHAOTIC.class);
        this.clazz((Supplier)DEContent.BOW_WYVERN, RenderModularBow.BOW_WYVERN.class);
        this.clazz((Supplier)DEContent.BOW_DRACONIC, RenderModularBow.BOW_DRACONIC.class);
        this.clazz((Supplier)DEContent.BOW_CHAOTIC, RenderModularBow.BOW_CHAOTIC.class);
        this.clazz((Supplier)DEContent.STAFF_DRACONIC, RenderModularStaff.STAFF_DRACONIC.class);
        this.clazz((Supplier)DEContent.STAFF_CHAOTIC, RenderModularStaff.STAFF_CHAOTIC.class);
        this.clazz((Supplier)DEContent.HOE_WYVERN, RenderModularHoe.HOE_WYVERN.class);
        this.clazz((Supplier)DEContent.HOE_DRACONIC, RenderModularHoe.HOE_DRACONIC.class);
        this.clazz((Supplier)DEContent.HOE_CHAOTIC, RenderModularHoe.HOE_CHAOTIC.class);
        this.clazz((Supplier)DEContent.CHESTPIECE_WYVERN, RenderModularChestpiece.CHESTPIECE_WYVERN.class);
        this.clazz((Supplier)DEContent.CHESTPIECE_DRACONIC, RenderModularChestpiece.CHESTPIECE_DRACONIC.class);
        this.clazz((Supplier)DEContent.CHESTPIECE_CHAOTIC, RenderModularChestpiece.CHESTPIECE_CHAOTIC.class);
    }

    protected void simpleItem(DeferredHolder<? extends Item, ? extends Item> item) {
        this.simpleItem(item, "item");
    }

    protected void simpleItem(DeferredHolder<? extends Item, ? extends Item> item, String textureFolder) {
        ResourceLocation reg = item.getId();
        this.simpleItem(item, ResourceLocation.fromNamespaceAndPath((String)reg.getNamespace(), (String)(textureFolder + "/" + reg.getPath())));
    }

    protected void simpleItem(DeferredHolder<? extends Item, ? extends Item> item, ResourceLocation texture) {
        ResourceLocation reg = item.getId();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    protected void multiLayerItem(DeferredHolder<? extends Item, ? extends Item> item, ResourceLocation texture, ResourceLocation overlay) {
        ResourceLocation reg = item.getId();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture)).texture("layer1", overlay);
    }

    protected void multiLayerItem(Item item, ResourceLocation texture, ResourceLocation overlay) {
        ResourceLocation reg = BuiltInRegistries.ITEM.getKey((Object)item);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(reg.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture)).texture("layer1", overlay);
    }

    protected void blockItem(DeferredHolder<? extends Block, ? extends Block> block) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = block.getId();
        this.blockItem(block, ResourceLocation.fromNamespaceAndPath((String)reg.getNamespace(), (String)("block/" + reg.getPath())));
    }

    protected void blockItem(DeferredHolder<? extends Block, ? extends Block> block, ResourceLocation blockModel) {
        if (block == null) {
            return;
        }
        ResourceLocation reg = block.getId();
        ((ItemModelBuilder)this.getBuilder(reg.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(blockModel));
    }

    protected void dummyBlock(DeferredHolder<? extends Block, ? extends Block> block) {
        ((ItemModelBuilder)this.getBuilder(block.getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/generated"));
    }

    protected void dummyItem(DeferredHolder<? extends Item, ? extends Item> item) {
        ((ItemModelBuilder)this.getBuilder(item.getId().getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/generated"));
    }

    public String getName() {
        return "Draconic Evolution Item Models";
    }
}

