/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedPos;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.Portal;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.client.render.particle.ParticlePortal;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TilePortal
extends TileBCore {
    private final ManagedPos controllerPos = (ManagedPos)this.register((IManagedData)new ManagedPos("controller_pos", (BlockPos)null, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE}));
    private boolean hidden = false;
    private Player player = null;

    public TilePortal(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_PORTAL.get(), pos, state);
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos.set(this.worldPosition.subtract((Vec3i)controllerPos));
    }

    protected BlockPos getControllerPos() {
        return this.controllerPos.get() == null ? BlockPos.ZERO : this.worldPosition.subtract((Vec3i)this.controllerPos.get());
    }

    public TileDislocatorReceptacle getController() {
        BlockEntity tile = this.level.getBlockEntity(this.getControllerPos());
        return tile instanceof TileDislocatorReceptacle ? (TileDislocatorReceptacle)tile : null;
    }

    public boolean isPortalActive() {
        TileDislocatorReceptacle controller = this.getController();
        return controller != null && controller.isActive();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tick() {
        if (this.hidden && this.player != null) {
            BlockState state = this.getBlockState();
            if (!state.is((Block)DEContent.PORTAL.get())) {
                this.hidden = false;
                this.player = null;
                this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)Portal.VISIBLE, (Comparable)Boolean.valueOf(true)), 0, 0);
                return;
            }
            Direction.Axis axis = (Direction.Axis)state.getValue(Portal.AXIS);
            Vector3 vec = Vector3.fromTileCenter((BlockEntity)this).subtract(Vector3.fromEntity((Entity)this.player));
            double dist = Math.abs(axis == Direction.Axis.X ? vec.x : (axis == Direction.Axis.Y ? vec.y : vec.z));
            if (dist > 1.5) {
                this.hidden = false;
                this.player = null;
                this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)Portal.VISIBLE, (Comparable)Boolean.valueOf(true)), 0, 0);
            }
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        double distanceMod = Utils.getDistance((double)((double)this.worldPosition.getX() + 0.5), (double)((double)this.worldPosition.getY() + 0.5), (double)((double)this.worldPosition.getZ() + 0.5), (double)player.getX(), (double)player.getY(), (double)player.getZ());
        if (this.level.random.nextInt(Math.max((int)(distanceMod * (distanceMod / 5.0)), 1)) == 0) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            if (!state.is((Block)DEContent.PORTAL.get())) {
                return;
            }
            Direction.Axis axis = (Direction.Axis)state.getValue(Portal.AXIS);
            double rD1 = this.level.random.nextDouble();
            double rD2 = this.level.random.nextDouble();
            double rO1 = -0.1 + this.level.random.nextDouble() * 0.2;
            double rO2 = -0.1 + this.level.random.nextDouble() * 0.2;
            if (axis == Direction.Axis.Z && player.getZ() < (double)this.worldPosition.getZ() + 0.5) {
                mc.particleEngine.add((Particle)new ParticlePortal((ClientLevel)this.level, Vector3.fromTile((BlockEntity)this).add(rD1, rD2, 0.0), Vector3.fromTile((BlockEntity)this).add(rD1 + rO1, rD2 + rO2, 0.75)));
            } else if (axis == Direction.Axis.Z && player.getZ() > (double)this.worldPosition.getZ() + 0.5) {
                mc.particleEngine.add((Particle)new ParticlePortal((ClientLevel)this.level, Vector3.fromTile((BlockEntity)this).add(rD1, rD2, 1.0), Vector3.fromTile((BlockEntity)this).add(rD1 + rO1, rD2 + rO2, 0.25)));
            } else if (axis == Direction.Axis.X && player.getX() < (double)this.worldPosition.getX() + 0.5) {
                mc.particleEngine.add((Particle)new ParticlePortal((ClientLevel)this.level, Vector3.fromTile((BlockEntity)this).add(0.0, rD1, rD2), Vector3.fromTile((BlockEntity)this).add(0.75, rD1 + rO1, rD2 + rO2)));
            } else if (axis == Direction.Axis.X && player.getX() > (double)this.worldPosition.getX() + 0.5) {
                mc.particleEngine.add((Particle)new ParticlePortal((ClientLevel)this.level, Vector3.fromTile((BlockEntity)this).add(1.0, rD1, rD2), Vector3.fromTile((BlockEntity)this).add(0.25, rD1 + rO1, rD2 + rO2)));
            } else if (axis == Direction.Axis.Y && player.getY() + (double)player.getEyeHeight() > (double)this.worldPosition.getY() + 0.5) {
                mc.particleEngine.add((Particle)new ParticlePortal((ClientLevel)this.level, Vector3.fromTile((BlockEntity)this).add(rD1, 1.0, rD2), Vector3.fromTile((BlockEntity)this).add(rD1 + rO1, 0.25, rD2 + rO2)));
            } else if (axis == Direction.Axis.Y && player.getY() + (double)player.getEyeHeight() < (double)this.worldPosition.getY() + 0.5) {
                mc.particleEngine.add((Particle)new ParticlePortal((ClientLevel)this.level, Vector3.fromTile((BlockEntity)this).add(rD1, 0.0, rD2), Vector3.fromTile((BlockEntity)this).add(rD1 + rO1, 0.75, rD2 + rO2)));
            }
        }
    }

    public void clientArrived(Player player) {
        BlockState state = this.getBlockState();
        if (state.is((Block)DEContent.PORTAL.get()) && this.level != null) {
            this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)Portal.VISIBLE, (Comparable)Boolean.valueOf(false)), 0, 0);
            this.hidden = true;
            this.player = player;
        }
    }
}

