/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.draconicevolution.DEOldConfig;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.inventory.DisenchanterMenu;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class TileDisenchanter
extends TileBCore
implements MenuProvider,
IInteractTile {
    public TileItemStackHandler itemHandler = new TileItemStackHandler((BlockEntity)this, 3).setSlotValidator(0, stack -> stack.isEnchanted() && ModHelper.canRemoveEnchants(stack)).setSlotValidator(1, itemStack -> itemStack.is(Items.BOOK));

    public TileDisenchanter(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_DISENCHANTER.get(), pos, state);
        this.capManager.setManaged("inventory", Capabilities.ItemHandler.BLOCK, (INBTSerializable)this.itemHandler, new Direction[0]).saveBoth();
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileDisenchanter.capability((RegisterCapabilitiesEvent)event, DEContent.TILE_DISENCHANTER, (BlockCapability)Capabilities.ItemHandler.BLOCK);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int pid) {
        ItemStack input = this.itemHandler.getStackInSlot(0);
        ItemStack books = this.itemHandler.getStackInSlot(1);
        ItemStack output = this.itemHandler.getStackInSlot(2);
        if (input.isEmpty() || !input.isEnchanted() || books.isEmpty() || books.getCount() <= 0 || !output.isEmpty()) {
            return;
        }
        ItemEnchantments list = (ItemEnchantments)input.get(DataComponents.ENCHANTMENTS);
        if (list == null) {
            return;
        }
        ResourceKey target = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)data.readResourceLocation());
        for (Holder enchantHolder : list.keySet()) {
            int repairCost;
            int lvl = list.getLevel(enchantHolder);
            if (!target.equals(enchantHolder.getKey())) continue;
            Enchantment enchantment = (Enchantment)enchantHolder.value();
            int cost = this.getCostInLevels(enchantment, lvl);
            if (!client.getAbilities().instabuild && cost > client.experienceLevel) {
                client.sendSystemMessage((Component)Component.translatable((String)"disenchanter.draconicevolution.not_enough_levels", (Object[])new Object[]{cost}).withStyle(ChatFormatting.RED));
                return;
            }
            if (!client.getAbilities().instabuild) {
                client.giveExperienceLevels(-cost);
            }
            books.shrink(1);
            if (books.getCount() <= 0) {
                this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
            }
            if ((repairCost = ((Integer)input.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue()) > 0) {
                repairCost -= (int)((double)repairCost * (1.0 / (double)list.size()));
                input.set(DataComponents.REPAIR_COST, (Object)Math.max(repairCost, 0));
            }
            ItemStack book = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantHolder, lvl));
            this.itemHandler.setStackInSlot(2, book);
            EnchantmentHelper.updateEnchantments((ItemStack)input, mutable -> mutable.removeIf(e -> e == enchantHolder));
            return;
        }
    }

    public int getCostInLevels(Enchantment e, int level) {
        int max = e.getMaxLevel();
        return (int)((double)(20 - (max == 1 ? 0 : (max == 2 ? 7 : 10))) * 0.35 * DEOldConfig.disenchnaterCostMultiplyer) * level;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new DisenchanterMenu(currentWindowIndex, player.getInventory(), this);
    }

    public InteractionResult useWithoutItem(BlockState state, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            player.openMenu((MenuProvider)this, this.worldPosition);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }
}

